/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.servicechain;

import com.digiwin.app.autoconfigure.condition.DWServiceChainEnableCondition;
import com.digiwin.app.service.interceptor.http.DWHttpClientInterceptor;
import com.digiwin.app.service.interceptor.http.DWServiceChainHttpRequestHandler;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class DWServiceChainAOPHttpAutoConfiguration
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        if (DWServiceChainEnableCondition.isEnabled()) {
            DWServiceChainHttpRequestHandler interceptor = new DWServiceChainHttpRequestHandler();
            registry.addInterceptor((HandlerInterceptor)interceptor);
        }
    }

    @Bean(value={"dw-httpclient-aop"})
    @Conditional(value={DWServiceChainEnableCondition.class})
    public DefaultPointcutAdvisor dwHttpClientInterceptor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("within(org.apache.http.client.HttpClient+) && execution(public org.apache.http.HttpResponse execute(..))");
        DWHttpClientInterceptor interceptor = new DWHttpClientInterceptor();
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        return advisor;
    }
}

