/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.event;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.gateway.controller.DWInitializationController;
import com.digiwin.gateway.event.DWInitEntryPointConfig;
import com.digiwin.gateway.event.DWInitializationEvent;
import com.digiwin.gateway.event.DWMobileInitializationEvent;
import com.digiwin.gateway.event.KanbanUserInfoSyncInit;
import com.digiwin.gateway.filter.DWCrossDomainProperties;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class DWInitializationEventAutoConfiguration {
    private static Log log = LogFactory.getLog(DWInitializationEventAutoConfiguration.class);
    public static final String KEY_MOBILE_URL = "mobileUrl";
    public static final String KEY_MOBILE_API_INIT = "mobileApiInit";

    public DWInitializationEventAutoConfiguration(Environment environment) {
        try {
            String api = environment.getProperty(KEY_MOBILE_API_INIT, "");
            log.info((Object)("-DWMobileInitializationEvent-check required property's key->mobileApiInit=" + api));
            if (!api.isEmpty()) {
                log.info((Object)"-DWMobileInitializationEvent-register initialization event.");
                DWMobileInitializationEvent initializationEvent = new DWMobileInitializationEvent();
                String url = environment.getProperty(KEY_MOBILE_URL, "");
                initializationEvent.setMobileUrl(url);
                initializationEvent.setMobileApiInitPath(api);
                DWInitEntryPointConfig.register((DWInitializationEvent)initializationEvent, (int)100);
            }
        }
        catch (Exception e) {
            throw new DWRuntimeException("register initialization event failed. check logs for details!", (Throwable)e);
        }
    }

    @Bean
    public DWCrossDomainProperties.UrlPatterns dwInitializationControllerUrlPatterns() {
        return new DWCrossDomainProperties.UrlPatterns(new String[]{"/api/app/initialize"});
    }

    @Bean
    public DWInitializationController dWInitializationController(RequestMappingHandlerMapping requestMappingHandlerMapping, ObjectProvider<List<DWInitializationEvent>> eventListObjectProvider) throws Exception {
        DWInitializationController controller = new DWInitializationController();
        RequestMappingInfo eaiRestfulMappingInfo = RequestMappingInfo.paths((String[])new String[]{"/api/app/initialize"}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json"}).build();
        requestMappingHandlerMapping.registerMapping(eaiRestfulMappingInfo, (Object)controller, DWInitializationController.class.getDeclaredMethod("initialize", new Class[0]));
        List eventList = (List)eventListObjectProvider.getIfAvailable();
        if (eventList != null) {
            for (DWInitializationEvent event : eventList) {
                DWInitEntryPointConfig.register((DWInitializationEvent)event);
            }
        }
        return controller;
    }

    @Bean
    public KanbanUserInfoSyncInit kanbanUserInfoSyncInit() {
        return new KanbanUserInfoSyncInit();
    }
}

