/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.utils.DWTenantUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(value="tenantAutoConfiguration")
public class DWTenantAutoConfiguration {
    @Bean(name={"dwTenantUtils"})
    public DWTenantUtils dwTenantUtils(Environment environment) {
        this.initTenantConfig(environment);
        return new DWTenantUtils();
    }

    public void initTenantConfig(Environment environment) {
        String tenantEnabled = environment.getProperty("tenantEnabled", "true");
        String tenantColumnName = environment.getProperty("tenantColumnname", "tenantsid");
        DWTenantUtils.setTenantEnabled((boolean)Boolean.parseBoolean(tenantEnabled));
        DWTenantUtils.setTenantColumnName((String)tenantColumnName);
        String noneMultiTenantEnvRequireTenantSid = environment.getProperty("dap.none-multi-tenant-env.requires-tenant-sid", "false");
        DWTenantUtils.setNoneTenantEnvRequiresTenantSid((boolean)Boolean.parseBoolean(noneMultiTenantEnvRequireTenantSid));
        String noneMultiTenantEnvRequireTenantProfile = environment.getProperty("dap.none-multi-tenant-env.requires-tenant-profile", "false");
        DWTenantUtils.setNoneTenantEnvRequiresTenantProfile((boolean)Boolean.parseBoolean(noneMultiTenantEnvRequireTenantProfile));
    }
}

