/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.condition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class DWNotRunningFromIDECondition
implements Condition {
    private static Log log = LogFactory.getLog(DWNotRunningFromIDECondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return !DWNotRunningFromIDECondition.isRunningFromIDE(context.getEnvironment());
    }

    public static boolean isRunningFromIDE(Environment environment) {
        boolean checkRunningFromIDE = Boolean.parseBoolean(environment.getProperty("dap_check_running_from_ide_enabled", "true"));
        if (!checkRunningFromIDE) {
            log.error((Object)("dap_check_running_from_ide_enabled = " + checkRunningFromIDE), (Throwable)new Exception("please remove this property if your JVM is running from IDE!"));
            return false;
        }
        if (DWNotRunningFromIDECondition.isRunningFromIntelliJIDEA(environment)) {
            return true;
        }
        return DWNotRunningFromIDECondition.isRunningFromEclipse(environment);
    }

    private static boolean isRunningFromIntelliJIDEA(Environment environment) {
        String targetClassName = null;
        boolean fromIntellij = false;
        try {
            targetClassName = Class.forName("com.intellij.rt.execution.application.AppMainV2").getName();
            fromIntellij = true;
        }
        catch (ClassNotFoundException e) {
            try {
                targetClassName = Class.forName("com.intellij.rt.execution.application.AppMain").getName();
                fromIntellij = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        log.debug((Object)("This JVM is running from Intellij IDEA = " + fromIntellij));
        if (fromIntellij) {
            log.debug((Object)("mapping exist class = " + targetClassName));
        }
        return fromIntellij;
    }

    private static boolean isRunningFromEclipse(Environment environment) {
        return false;
    }
}

