/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.mybatis.config;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.io.IOException;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DWMybatisModuleBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    MybatisPlusProperties mybatisPlusProperties;
    ApplicationContext applicationContext;

    public DWMybatisModuleBeanDefinitionRegistryPostProcessor(MybatisPlusProperties mybatisPlusProperties) {
        this.mybatisPlusProperties = mybatisPlusProperties;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        MapperScannerConfigurer mapperConfigurer = (MapperScannerConfigurer)SpringContextUtils.getContext().getBean(MapperScannerConfigurer.class);
        mapperConfigurer.setApplicationContext(this.applicationContext);
        mapperConfigurer.postProcessBeanDefinitionRegistry(registry);
        SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)SpringContextUtils.getContext().getBean(SqlSessionFactory.class);
        Configuration configuration = sqlSessionFactory.getConfiguration();
        for (String mapperLocation : this.mybatisPlusProperties.getMapperLocations()) {
            Resource[] resources = null;
            try {
                for (Resource resource : resources = this.applicationContext.getResources(mapperLocation)) {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resource.getInputStream(), configuration, resource.toString(), configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

