/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWFasyncMongoAutoConfiguration {
    private static Log log = LogFactory.getLog(DWFasyncMongoAutoConfiguration.class);

    @Bean(value={"fasyncMongo"})
    public MongoClient mongoClient(Environment environment) throws Exception {
        String url = environment.getProperty("fasyncMongoUrl");
        String port = environment.getProperty("fasyncMongoPort", "");
        String user = environment.getProperty("fasyncMongoUser", "");
        String password = environment.getProperty("fasyncMongoPassword", "");
        String databaseName = environment.getProperty("fasyncMongoDatabaseName", "");
        this.check("fasyncMongoPort", port);
        this.check("fasyncMongoUser", user);
        this.check("fasyncMongoPassword", password);
        this.check("fasyncMongoDatabaseName", databaseName);
        int connectionsPerHost = (Integer)environment.getProperty("fasyncMongoConnectionsPerHost", Integer.class, (Object)200);
        int maxWaitTime = (Integer)environment.getProperty("fasyncMongoMaxWaitTime", Integer.class, (Object)120000);
        int maxConnectionIdleTime = (Integer)environment.getProperty("fasyncMongoMaxConnectionIdleTime", Integer.class, (Object)60000);
        int maxConnectionLifeTime = (Integer)environment.getProperty("fasyncMongoMaxConnectionLifeTime", Integer.class, (Object)120000);
        int connectTimeout = (Integer)environment.getProperty("fasyncMongoConnectTimeout", Integer.class, (Object)10000);
        int socketTimeout = (Integer)environment.getProperty("fasyncMongoSocketTimeout", Integer.class, (Object)15000);
        boolean retryWrites = (Boolean)environment.getProperty("fasyncMongoRetryWrites", Boolean.class, (Object)true);
        boolean sslEnabled = (Boolean)environment.getProperty("fasyncMongoSslEnabled", Boolean.class, (Object)false);
        MongoClientOptions options = MongoClientOptions.builder().connectionsPerHost(connectionsPerHost).maxWaitTime(maxWaitTime).maxConnectionIdleTime(maxConnectionIdleTime).maxConnectionLifeTime(maxConnectionLifeTime).connectTimeout(connectTimeout).socketTimeout(socketTimeout).retryWrites(retryWrites).sslEnabled(sslEnabled).build();
        log.info((Object)("[DWFasyncMongoAutoConfiguration] MongoClientOptions: " + String.valueOf(options)));
        ServerAddress serverAddress = new ServerAddress(url, Integer.valueOf(port).intValue());
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
        serverAddresses.add(serverAddress);
        MongoCredential credential = MongoCredential.createScramSha1Credential((String)user, (String)databaseName, (char[])password.toCharArray());
        MongoClient client = new MongoClient(serverAddresses, credential, options);
        return client;
    }

    private void check(String propertyName, String value) throws Exception {
        if (value == null || value.trim().isEmpty()) {
            log.error((Object)("[DWFasyncMongoAutoConfiguration] Property " + propertyName + " is empty or null"));
            throw new IllegalArgumentException("[DWFasyncMongoAutoConfiguration] Property " + propertyName + " is empty or null");
        }
    }
}

