/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWJavaxValidationEnableCondition;
import com.digiwin.app.autoconfigure.condition.DWModularModeCondition;
import com.digiwin.app.autoconfigure.validation.DWModuleLayerValidationConfiguration;
import com.digiwin.app.module.spring.DWModuleSpringUtils;
import com.digiwin.app.validation.DWModuleResourceBundleLocator;
import com.digiwin.app.validation.DWResourceBundleLocator;
import jakarta.annotation.PostConstruct;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@Configuration
@Conditional(value={DWModularModeCondition.class})
public class DWModuleValidationAutoConfiguration {
    @PostConstruct
    public void init() {
        DWModuleSpringUtils.registerModuleConfigurationClass(DWModuleLayerValidationConfiguration.class);
        DWModuleSpringUtils.registerModuleBeforeRefreshListener(DWModuleValidationAutoConfiguration::beforeModuleApplicationContextRefresh);
    }

    @Bean(name={"dao-LocalValidatorFactoryBean"})
    @Conditional(value={DWJavaxValidationEnableCondition.class})
    public LocalValidatorFactoryBean getLocalValidatorFactoryBean() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        DWResourceBundleLocator rbLocator = new DWResourceBundleLocator();
        ResourceBundleMessageInterpolator interpolator = new ResourceBundleMessageInterpolator((ResourceBundleLocator)rbLocator);
        factoryBean.setMessageInterpolator((MessageInterpolator)interpolator);
        return factoryBean;
    }

    @Bean(name={"dao-MethodValidationPostProcessor"})
    @Conditional(value={DWJavaxValidationEnableCondition.class})
    public MethodValidationPostProcessor getMethodValidationPostProcessor(@Autowired @Qualifier(value="dao-LocalValidatorFactoryBean") LocalValidatorFactoryBean factoryBean) {
        MethodValidationPostProcessor processor = new MethodValidationPostProcessor();
        processor.setValidatorFactory((ValidatorFactory)factoryBean);
        return processor;
    }

    protected static void beforeModuleApplicationContextRefresh(String moduleName, GenericXmlApplicationContext applicationContext) {
        if (DWJavaxValidationEnableCondition.isEnabled(moduleName)) {
            LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
            DWModuleResourceBundleLocator rbLocator = new DWModuleResourceBundleLocator(moduleName);
            ResourceBundleMessageInterpolator interpolator = new ResourceBundleMessageInterpolator((ResourceBundleLocator)rbLocator);
            factoryBean.setMessageInterpolator((MessageInterpolator)interpolator);
            applicationContext.getBeanFactory().registerSingleton("dao-LocalValidatorFactoryBean", (Object)factoryBean);
            factoryBean.afterPropertiesSet();
        }
    }
}

