/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.service.restful.DWRestfulHeaderRepository;
import com.digiwin.app.service.restful.DWRestfulServiceDefinitionParser;
import com.digiwin.gateway.filter.DWRestfulMethodLocateFilter;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DWRestfulHeaderRepository.class})
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
public class DWRestfulStandardServiceAutoConfiguration {
    public static final int RESTFUL_URL_RULE_FILTER_ORDER = 100;
    public static final int DWRESTFULMETHOD_LOCATE_FILTER_ORDER = 101;

    @Bean(value={"DWRestfulHeaderRepository"})
    public DWRestfulHeaderRepository getDWRestfulHeaderRepository() {
        return new DWRestfulHeaderRepository();
    }

    @Bean(value={"DWRestfulServiceParser"})
    public DWRestfulServiceDefinitionParser getDWRestfulServiceParser(DWRestfulHeaderRepository restfulHeaderRepository) {
        return new DWRestfulServiceDefinitionParser(restfulHeaderRepository);
    }

    @Configuration
    @AutoConfigureAfter(value={DWContainerAutoConfiguration.class})
    public static class RestfulStandardConfiguration {
        @Autowired
        private ApplicationContext context;

        @Bean
        public DWRestfulMethodLocateFilter dwRestfulMethodLocateFilterBean(DWContainerContext containerContext) {
            return new DWRestfulMethodLocateFilter(containerContext);
        }

        @Bean
        public FilterRegistrationBean<DWRestfulMethodLocateFilter> dwRestfulMethodLocateFilter() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)((DWRestfulMethodLocateFilter)this.context.getBean(DWRestfulMethodLocateFilter.class)));
            registration.addUrlPatterns(new String[]{"/restful/standard/*"});
            registration.setOrder(101);
            return registration;
        }
    }
}

