/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.module;

import com.digiwin.app.autoconfigure.DWContainerAutoConfiguration;
import com.digiwin.app.module.DWModularServiceModuleInfoProvider;
import com.digiwin.app.module.DWModuleClassLoader;
import com.digiwin.app.module.DWModuleServiceProcessor;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.module.spring.DWSpringServiceBuilder;
import com.digiwin.app.service.DWServiceBuilder;
import com.digiwin.app.service.DWServiceDefinitionParser;
import com.digiwin.app.service.DWServiceGroupInfoProvider;
import com.digiwin.app.service.DWServiceLookupProcessor;
import com.digiwin.app.service.commons.config.DWServiceCommonsProvider;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={DWModuleClassLoader.class})
@AutoConfigureBefore(value={DWContainerAutoConfiguration.class})
public class DWModuleContainerAutoConfiguration {
    @ConditionalOnMissingBean(value={DWServiceBuilder.class})
    @Bean(value={"dw-service-builder"})
    public DWServiceBuilder getDWSpringServiceBuilder() {
        DWSpringServiceBuilder builder = new DWSpringServiceBuilder();
        DWServiceInfo.setServiceBuilder((DWServiceBuilder)builder);
        return builder;
    }

    @ConditionalOnMissingBean(value={DWServiceLookupProcessor.class})
    @Bean(value={"dw-service-lookup-processor"})
    public DWModuleServiceProcessor getDWModuleServiceProcessor(List<DWServiceDefinitionParser> serviceDefParsers, @Nullable DWServiceCommonsProvider serviceCommonsProvider) {
        DWModuleServiceProcessor processor = new DWModuleServiceProcessor(serviceDefParsers);
        if (serviceCommonsProvider != null) {
            processor.setCommonsInterfaces(serviceCommonsProvider.getInterfaceServices());
            processor.setCommonsImplements(serviceCommonsProvider.getImplementServices());
        }
        return processor;
    }

    @ConditionalOnMissingBean(value={DWServiceGroupInfoProvider.class})
    @Bean(value={"dw-service-group-info-provider"})
    public DWServiceGroupInfoProvider getServiceGroupInfoProvider() {
        return new DWModularServiceModuleInfoProvider();
    }
}

