/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DWFasyncMongoAutoConfiguration {
    private static Log log = LogFactory.getLog(DWFasyncMongoAutoConfiguration.class);

    @Bean(value={"fasyncMongo"})
    public MongoClient mongoClient(Environment environment) throws Exception {
        String url = environment.getProperty("fasyncMongoUrl");
        String user = environment.getProperty("fasyncMongoUser", "");
        String password = environment.getProperty("fasyncMongoPassword", "");
        String databaseName = environment.getProperty("fasyncMongoDatabaseName", "");
        int connectionsPerHost = (Integer)environment.getProperty("fasyncMongoConnectionsPerHost", Integer.class, (Object)200);
        int maxWaitTime = (Integer)environment.getProperty("fasyncMongoMaxWaitTime", Integer.class, (Object)120000);
        int maxConnectionIdleTime = (Integer)environment.getProperty("fasyncMongoMaxConnectionIdleTime", Integer.class, (Object)60000);
        int maxConnectionLifeTime = (Integer)environment.getProperty("fasyncMongoMaxConnectionLifeTime", Integer.class, (Object)120000);
        int connectTimeout = (Integer)environment.getProperty("fasyncMongoConnectTimeout", Integer.class, (Object)10000);
        int socketTimeout = (Integer)environment.getProperty("fasyncMongoSocketTimeout", Integer.class, (Object)15000);
        boolean retryWrites = (Boolean)environment.getProperty("fasyncMongoRetryWrites", Boolean.class, (Object)true);
        boolean sslEnabled = (Boolean)environment.getProperty("fasyncMongoSslEnabled", Boolean.class, (Object)false);
        MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder().applyToConnectionPoolSettings(builder -> builder.maxSize(connectionsPerHost).maxWaitTime((long)maxWaitTime, TimeUnit.MILLISECONDS).maxConnectionIdleTime((long)maxConnectionIdleTime, TimeUnit.MILLISECONDS).maxConnectionLifeTime((long)maxConnectionLifeTime, TimeUnit.MILLISECONDS)).applyToSocketSettings(builder -> builder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS).readTimeout((long)socketTimeout, TimeUnit.MILLISECONDS)).retryWrites(retryWrites).applyToSslSettings(builder -> builder.enabled(sslEnabled));
        if (url != null && !url.isEmpty()) {
            String port = environment.getProperty("fasyncMongoPort", "");
            this.check("fasyncMongoPort", port);
            this.check("fasyncMongoUser", user);
            this.check("fasyncMongoPassword", password);
            this.check("fasyncMongoDatabaseName", databaseName);
            log.info((Object)("[DWFasyncMongoAutoConfiguration] MongoClientOptions: " + String.valueOf(mongoClientSettingsBuilder.build())));
            ServerAddress serverAddress = new ServerAddress(url, Integer.valueOf(port).intValue());
            ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
            serverAddresses.add(serverAddress);
            mongoClientSettingsBuilder.applyToClusterSettings(builder -> builder.hosts(serverAddresses));
            MongoCredential credential = MongoCredential.createScramSha1Credential((String)user, (String)databaseName, (char[])password.toCharArray());
            mongoClientSettingsBuilder.credential(credential);
            MongoClient client = MongoClients.create((MongoClientSettings)mongoClientSettingsBuilder.build());
            return client;
        }
        String fasyncMongoType = environment.getProperty("fasyncMongoType", "");
        String fasyncMongoCluster = environment.getProperty("fasyncMongoCluster", "");
        String fasyncMongoArgs = environment.getProperty("fasyncMongoArgs", "");
        this.check("fasyncMongoType", fasyncMongoType);
        this.check("fasyncMongoCluster", fasyncMongoCluster);
        StringBuilder uri = new StringBuilder();
        uri.append(fasyncMongoType);
        uri.append("://");
        uri.append(user);
        uri.append(":");
        uri.append(password);
        uri.append("@");
        uri.append(fasyncMongoCluster);
        uri.append("/");
        uri.append(databaseName);
        if (fasyncMongoArgs != null && !"".equals(fasyncMongoArgs)) {
            uri.append("?");
            uri.append(fasyncMongoArgs);
        }
        mongoClientSettingsBuilder.applyConnectionString(new ConnectionString(uri.toString()));
        MongoClient client = MongoClients.create((MongoClientSettings)mongoClientSettingsBuilder.build());
        return client;
    }

    private void check(String propertyName, String value) throws Exception {
        if (value == null || value.trim().isEmpty()) {
            log.error((Object)("[DWFasyncMongoAutoConfiguration] Property " + propertyName + " is empty or null"));
            throw new IllegalArgumentException("[DWFasyncMongoAutoConfiguration] Property " + propertyName + " is empty or null");
        }
    }
}

