/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.eai.merge;

import com.digiwin.app.eai.DWEAIAttachAppAuthProperties;
import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.app.eai.merge.DWSourceAppAwareEAIAttachAppAuthProperties;
import com.digiwin.app.merge.DWSourceAppAwareUtils;
import org.springframework.core.env.Environment;

public class DWSourceAppAwareEAIProperties
extends DWEAIProperties {
    private DWEAIProperties source;
    private DWEAIAttachAppAuthProperties sourceAppAwareWEAIAttachAppAuthProperties = null;
    private Environment environment;

    public DWSourceAppAwareEAIProperties(DWEAIProperties source) {
        this.source = source;
    }

    public void setEnvironement(Environment environment) {
        this.environment = environment;
    }

    public String getContextPath() {
        return this.source.getContextPath();
    }

    public void setContextPath(String contextPath) {
        this.source.setContextPath(contextPath);
    }

    public void setRestfulServiceBasePath(String restfulServiceBasePath) {
        this.source.setRestfulServiceBasePath(restfulServiceBasePath);
    }

    public String getRestfulServiceBasePath() {
        if (this.environment != null) {
            String configKey = DWSourceAppAwareUtils.getSourceAppConfigKeyByCurrentAppId((String)"eaiRestfulUrl");
            String basePath = this.environment.getProperty(configKey);
            if ("@eaiRestfulUrl@".equals(basePath)) {
                basePath = null;
            }
            if (basePath != null) {
                basePath = basePath.trim();
            }
            if (basePath == null || basePath.isEmpty()) {
                return "/eai";
            }
            return basePath;
        }
        return this.source.getRestfulServiceBasePath();
    }

    public void setRestfulServicePathIdentifier(String id) {
        this.source.setRestfulServicePathIdentifier(id);
    }

    public String getRestfulServicePathIdentifier() {
        if (this.environment != null) {
            String configKey = DWSourceAppAwareUtils.getSourceAppConfigKeyByCurrentAppId((String)"eaiRestfulCustomId");
            String customId = this.environment.getProperty(configKey);
            if ("@eaiRestfulCustomId@".equals(customId)) {
                customId = null;
            }
            if (customId != null) {
                customId.trim();
            }
            return customId;
        }
        return this.source.getRestfulServicePathIdentifier();
    }

    public String getRestfulServicePath() {
        if (this.environment == null) {
            return this.source.getRestfulServicePath();
        }
        String identifier = this.getRestfulServicePathIdentifier();
        if (identifier == null || identifier.isEmpty()) {
            return this.getRestfulServiceBasePath();
        }
        return String.join((CharSequence)"/", this.getRestfulServiceBasePath(), identifier);
    }

    public String getRestfulServiceCallbackPath() {
        if (this.environment == null) {
            return this.source.getRestfulServiceCallbackPath();
        }
        return this.getRestfulServicePath() + "/callback";
    }

    public String getRestfulServiceSyncProdPath() {
        if (this.environment == null) {
            return this.source.getRestfulServiceSyncProdPath();
        }
        return this.getRestfulServicePath() + "/syncProd";
    }

    public void setHostVer(String hostVer) {
        this.source.setHostVer(hostVer);
    }

    public String getHostVer() {
        if (this.environment != null) {
            String configKey = DWSourceAppAwareUtils.getSourceAppConfigKeyByCurrentAppId((String)"eaiHostVer");
            return this.environment.getProperty(configKey, "1.0.0");
        }
        return this.source.getHostVer();
    }

    public String getHostRetryTimes() {
        return this.source.getHostRetryTimes();
    }

    public void setHostRetryTimes(String hostRetryTimes) {
        this.source.setHostRetryTimes(hostRetryTimes);
    }

    public String getHostRetryInterval() {
        return this.source.getHostRetryInterval();
    }

    public void setHostRetryInterval(String hostRetryInterval) {
        this.source.setHostRetryInterval(hostRetryInterval);
    }

    public String getHostConcurrence() {
        return this.source.getHostConcurrence();
    }

    public void setHostConcurrence(String hostConcurrence) {
        this.source.setHostConcurrence(hostConcurrence);
    }

    public void setHostId(String hostId) {
        this.source.setHostId(hostId);
    }

    public void setHostUid(String hostUid) {
        this.source.setHostUid(hostUid);
    }

    public void setHostProd(String hostProd) {
        this.source.setHostProd(hostProd);
    }

    public String getHostIp() {
        return this.source.getHostIp();
    }

    public void setHostIp(String hostIp) {
        this.source.setHostIp(hostIp);
    }

    public String getServerUrl() {
        return this.source.getServerUrl();
    }

    public void setServerUrl(String serverUrl) {
        this.source.setServerUrl(serverUrl);
    }

    public String getServerRegisterServicePath() {
        return this.source.getServerRegisterServicePath();
    }

    public void setServerRegisterServicePath(String serverRegisterServicePath) {
        this.source.setServerRegisterServicePath(serverRegisterServicePath);
    }

    public boolean isStandardHostProduct() {
        return this.source.isStandardHostProduct();
    }

    public void setStandardHostProduct(boolean standardHostProduct) {
        this.source.setStandardHostProduct(standardHostProduct);
    }

    public DWEAIAttachAppAuthProperties getAttachAppAuthProperties() {
        if (this.sourceAppAwareWEAIAttachAppAuthProperties == null) {
            this.sourceAppAwareWEAIAttachAppAuthProperties = new DWSourceAppAwareEAIAttachAppAuthProperties(super.getAttachAppAuthProperties());
        }
        return this.sourceAppAwareWEAIAttachAppAuthProperties;
    }

    public void setRedisKeyExpireTime(long redisKeyExpireTime) {
        this.source.setRedisKeyExpireTime(redisKeyExpireTime);
    }

    public long getRedisKeyExpireTime() {
        return this.source.getRedisKeyExpireTime();
    }

    public void setFasyncTaskExecutorServiceThreads(int fasyncTaskExecutorServiceThreads) {
        this.source.setFasyncTaskExecutorServiceThreads(fasyncTaskExecutorServiceThreads);
    }

    public int getFasyncTaskExecutorServiceThreads() {
        return this.source.getFasyncTaskExecutorServiceThreads();
    }

    public void setFasyncTaskExecutorServiceThreadNamePrefix(String fasyncTaskExecutorServiceThreadNamePrefix) {
        this.source.setFasyncTaskExecutorServiceThreadNamePrefix(fasyncTaskExecutorServiceThreadNamePrefix);
    }

    public String getFasyncTaskExecutorServiceThreadNamePrefix() {
        return this.source.getFasyncTaskExecutorServiceThreadNamePrefix();
    }

    public void setFasyncTaskPoolEnable(boolean fasyncTaskPoolEnable) {
        this.source.setFasyncTaskPoolEnable(fasyncTaskPoolEnable);
    }

    public boolean getFasyncTaskPoolEnable() {
        return this.source.getFasyncTaskPoolEnable();
    }

    public String getHostId() {
        if (this.environment != null) {
            String configKey = DWSourceAppAwareUtils.getSourceAppConfigKeyByCurrentAppId((String)"eaiHostId");
            return this.environment.getProperty(configKey, DWSourceAppAwareUtils.getCurrentAppId());
        }
        return this.source.getHostId();
    }

    public String getHostUid() {
        if (this.environment != null) {
            String configKey = DWSourceAppAwareUtils.getSourceAppConfigKeyByCurrentAppId((String)"eaiHostUid");
            return this.environment.getProperty(configKey, DWSourceAppAwareUtils.getCurrentAppId());
        }
        return this.source.getHostUid();
    }

    public String getHostProd() {
        if (this.environment != null) {
            String configKey = DWSourceAppAwareUtils.getSourceAppConfigKeyByCurrentAppId((String)"eaiHostProd");
            return this.environment.getProperty(configKey, DWSourceAppAwareUtils.getCurrentAppId());
        }
        return this.source.getHostProd();
    }
}

