/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.condition.DWDbEnableCondition;
import com.digiwin.app.autoconfigure.condition.DWScheduleEnableCondition;
import java.util.HashSet;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DWAutoConfigurationImportFilter
implements AutoConfigurationImportFilter,
EnvironmentAware {
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean[] match(String[] autoConfigurationClasses, AutoConfigurationMetadata autoConfigurationMetadata) {
        HashSet<String> excludeAutoConfiguration = new HashSet<String>();
        if (DWDbEnableCondition.isDbUrlEmpty((Environment)this.environment)) {
            excludeAutoConfiguration.add("org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration");
        }
        if (!DWScheduleEnableCondition.isScheduleEnabled((Environment)this.environment)) {
            excludeAutoConfiguration.add("org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration");
        }
        boolean[] matches = new boolean[autoConfigurationClasses.length];
        for (int i = 0; i < autoConfigurationClasses.length; ++i) {
            matches[i] = !excludeAutoConfiguration.contains(autoConfigurationClasses[i]);
        }
        return matches;
    }

    private static void staticInitializer() {
    }
}

