/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure.event;

import com.digiwin.gateway.controller.DWTenantUserEmployeeController;
import com.digiwin.gateway.filter.DWCrossDomainProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnClass(value={DWTenantUserEmployeeController.class})
public class DWTenantUserEmployeeEventAutoConfiguration {
    public static final String API_TENANT_USER_JOINED = "/api/app/tenant/user/joined";
    public static final String API_TENANT_EMPLOYEE_DISABLED = "/api/app/tenant/emp/disabled";

    @Bean
    public DWCrossDomainProperties.UrlPatterns dwTenantUserEmployeeControllerUrlPatterns() {
        return new DWCrossDomainProperties.UrlPatterns(new String[]{API_TENANT_USER_JOINED, API_TENANT_EMPLOYEE_DISABLED});
    }

    @Bean
    public DWTenantUserEmployeeController dwTenantUserEmployeeController(@Qualifier(value="requestMappingHandlerMapping") RequestMappingHandlerMapping requestMappingHandlerMapping) throws Exception {
        DWTenantUserEmployeeController controller = new DWTenantUserEmployeeController();
        RequestMappingInfo.BuilderConfiguration options = new RequestMappingInfo.BuilderConfiguration();
        options.setTrailingSlashMatch(true);
        RequestMappingInfo onUserJoinedMappingInfo = RequestMappingInfo.paths((String[])new String[]{API_TENANT_USER_JOINED}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json"}).options(options).build();
        requestMappingHandlerMapping.registerMapping(onUserJoinedMappingInfo, (Object)controller, DWTenantUserEmployeeController.class.getDeclaredMethod("onUserJoined", new Class[0]));
        RequestMappingInfo onEmployeeDisabledMappingInfo = RequestMappingInfo.paths((String[])new String[]{API_TENANT_EMPLOYEE_DISABLED}).methods(new RequestMethod[]{RequestMethod.POST}).produces(new String[]{"application/json"}).options(options).build();
        requestMappingHandlerMapping.registerMapping(onEmployeeDisabledMappingInfo, (Object)controller, DWTenantUserEmployeeController.class.getDeclaredMethod("onEmployeeDisabled", new Class[0]));
        return controller;
    }
}

