/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.gateway.cache;

import com.digiwin.gateway.cache.DWCache;
import com.digiwin.gateway.cache.DWInMemoryCache;

public class DWInMemoryChanceCache
extends DWInMemoryCache
implements DWCache {
    private static final double DEFAULT_MIN_CACHE_CHANCE = 0.35;
    private static final double DEFAULT_MAX_CACHE_CHANCE = 0.7;
    private double cacheChance;

    public DWInMemoryChanceCache() {
        this(60);
    }

    public DWInMemoryChanceCache(int cleanUpPreSecond) {
        super(cleanUpPreSecond);
        this.cacheChance = 0.35 + Math.random() * 0.35;
    }

    public DWInMemoryChanceCache(double cacheChance) {
        this(cacheChance, 60);
    }

    public DWInMemoryChanceCache(double cacheChance, int cleanUpPreSecond) {
        super(cleanUpPreSecond);
        this.cacheChance = cacheChance > 1.0 ? 1.0 : (cacheChance < 0.0 ? 0.0 : cacheChance);
    }

    @Override
    public Object get(String key) throws Exception {
        if (this.isUseCache()) {
            return super.get(key);
        }
        return null;
    }

    @Override
    public void put(String key, Object value) throws Exception {
        this.put(key, value, -1);
    }

    public double getCacheChance() {
        return this.cacheChance;
    }

    private boolean isUseCache() {
        return Math.random() < this.cacheChance;
    }
}

