/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cache;

import com.digiwin.app.cache.DWCacheable;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.springframework.cache.interceptor.KeyGenerator;

public class DWCacheKeyGenerator
implements KeyGenerator {
    private static Map<String, Supplier<String>> replacements = new LinkedHashMap<String, Supplier<String>>();

    public Object generate(Object target, Method method, Object ... params) {
        String dwCacheableValue = null;
        DWCacheable[] dwCacheables = (DWCacheable[])method.getAnnotationsByType(DWCacheable.class);
        if (dwCacheables != null && dwCacheables.length > 0) {
            DWCacheable dwCacheable = dwCacheables[0];
            dwCacheableValue = dwCacheable.value();
        }
        return DWCacheKeyGenerator.generateKey(dwCacheableValue, params);
    }

    public static void registerReplacement(String replaceName, Supplier<String> replacement) {
        Objects.requireNonNull(replaceName);
        Objects.requireNonNull(replacement);
        replacements.put(replaceName, replacement);
    }

    public static Object generateKey(String dwCacheableValue, Object ... params) {
        boolean isUserTokenCache = false;
        if ("token".equals(dwCacheableValue)) {
            isUserTokenCache = true;
        }
        String key = null;
        if (isUserTokenCache) {
            key = params[0].toString();
        } else if (dwCacheableValue != null && dwCacheableValue.trim().length() > 0) {
            key = dwCacheableValue;
            for (Map.Entry<String, Supplier<String>> item : replacements.entrySet()) {
                if (!key.contains("{" + item.getKey() + "}")) continue;
                key = key.replaceAll("\\{" + item.getKey() + "\\}", item.getValue().get());
            }
        } else {
            key = "no_defined";
        }
        return key;
    }
}

