/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.mock.rap;

import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.local.mock.DWMockMethod;
import com.digiwin.app.container.local.mock.DWMockParameter;
import com.digiwin.app.container.local.mock.rap.DWRapMockInfoProvider;
import com.digiwin.app.service.AllowAnonymous;
import java.lang.reflect.Method;
import java.util.List;

public class DWRapMockMethod
extends DWMockMethod {
    private DWRapMockInfoProvider _mockDataProvider;
    private String _rapActionItemName;
    private boolean _allowAnonymous;

    public DWRapMockMethod(Method method, String rapActionItemName, String mockTargetMethodName, String requestUrl, List<DWMockParameter> parameters) {
        super(method, mockTargetMethodName, requestUrl, parameters);
        this._rapActionItemName = rapActionItemName;
        String mark = "@" + AllowAnonymous.class.getSimpleName().toLowerCase();
        this._allowAnonymous = this._rapActionItemName != null && this._rapActionItemName.trim().toLowerCase().endsWith(mark);
    }

    protected void setMockDataProvider(DWRapMockInfoProvider rapMockInfoProvider) {
        this._mockDataProvider = rapMockInfoProvider;
        String ipPort = rapMockInfoProvider == null ? "" : rapMockInfoProvider.getRapServiceIpPort();
        String projectId = rapMockInfoProvider == null ? "" : rapMockInfoProvider.getRapProjectId();
        StringBuilder mockInfo = new StringBuilder();
        mockInfo.append("Server:").append(ipPort).append(", Project Id:").append(projectId);
        this.setMockInfo(mockInfo.toString());
    }

    @Override
    public boolean allowAnonymous() {
        return this._allowAnonymous;
    }

    @Override
    public Object invoke(Object service, DWParameters parameters) throws Exception {
        if (this._mockDataProvider != null) {
            Object mockDataObject = this._mockDataProvider.getRealTimeMockDataObject(this.getMockUrl());
            return mockDataObject;
        }
        if (this.getMockDatas().size() > 0) {
            return this.getMockDatas().get(0).getOutput();
        }
        return null;
    }
}

