/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local;

import com.digiwin.app.container.DWAbstractHeaderRepository;
import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.log.ConfigurationUpdater;
import com.digiwin.app.log.Log4j2XmlHolder;
import com.digiwin.app.log.LogFactoryImplement;
import com.digiwin.app.service.DWSimpleServiceLocationInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWLocalHeaderRepository
extends DWAbstractHeaderRepository<DWHeader, DWSimpleServiceLocationInfo> {
    private static Log log = LogFactory.getLog(DWLocalHeaderRepository.class);
    private Map<DWHeader, Map<String, List<DWMethod>>> _methodMap = new HashMap<DWHeader, Map<String, List<DWMethod>>>();

    private static void staticInitializer() {
        if (LogFactoryImplement.getLogFactoryimplement().equals((Object)LogFactoryImplement.Implement.APACHE_COMMONS_LOGGING)) {
            try {
                String xml = Log4j2XmlHolder.getXml();
                ConfigurationUpdater.execute((String)xml);
            }
            catch (Throwable t) {
                log.warn((Object)"DWLocalHeaderRepository staticInitializer log failed!", t);
            }
        }
    }

    protected void afterRegister(String groupName, List<DWHeader> headers, List<DWHeader> oldHeaders) {
        this.createMethodMap(groupName, headers);
    }

    private void createMethodMap(String groupName, List<DWHeader> headers) {
        this._methodMap.entrySet().removeIf(item -> groupName.equals(((DWHeader)item.getKey()).getModuleName()));
        headers.forEach(header -> this._methodMap.put((DWHeader)header, header.getDWMethods()));
    }

    protected DWTargetAPI searchAPI(DWSimpleServiceLocationInfo locationInfo) {
        DWHeader header = this.getHeaders(locationInfo.getGroup()).stream().filter(h -> h.getServiceName().equals(locationInfo.getServiceName())).findFirst().orElse(null);
        if (header == null) {
            return DWTargetAPI.createInvalidAPI();
        }
        DWMethod method = null;
        List<DWMethod> methodList = null;
        Map<String, List<DWMethod>> methodMap = this._methodMap.get(header);
        if (methodMap != null && (methodList = methodMap.get(locationInfo.getMethodName())) != null) {
            method = methodList.stream().filter(m -> m.isMatch(locationInfo.getParameters())).findFirst().orElse(null);
        }
        return new DWTargetAPI(header, method);
    }

    static {
        DWLocalHeaderRepository.staticInitializer();
    }
}

