/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.local.developer;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceRepository;
import com.digiwin.app.container.local.developer.definer.DWDeveloperServiceDefiner;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import java.util.List;
import java.util.Map;

public class DWDeveloperServiceRepository
implements DWServiceRepository {
    protected Map<String, List<DWServiceInfo>> _services;

    public DWDeveloperServiceRepository() {
        this.initialize();
    }

    public DWService getService(DWHeader header, DWMethod method) throws Exception {
        DWServiceInfo serviceInfo = this.getServiceInfo(header);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getInstance();
    }

    public Map<String, List<DWServiceInfo>> getServiceInfos() {
        return this._services;
    }

    public List<DWServiceInfo> getServiceInfos(String groupName) {
        return this._services.get(groupName);
    }

    public DWServiceInfo getServiceInfo(String groupName, String serviceName) {
        List<DWServiceInfo> list = this._services.get(groupName);
        if (list == null) {
            return null;
        }
        return list.stream().filter(s -> s.getInterfaceType().getSimpleName().equals(serviceName)).findFirst().orElse(null);
    }

    private DWServiceInfo getServiceInfo(DWHeader header) {
        DWServiceInfo targetServiceInfo = null;
        String moduleName = header.getModuleName();
        List<DWServiceInfo> services = this._services.get(moduleName);
        if (services != null) {
            for (DWServiceInfo serviceInfo : services) {
                if (serviceInfo.getInterfaceType() != header.getServiceType()) continue;
                targetServiceInfo = serviceInfo;
                break;
            }
        }
        return targetServiceInfo;
    }

    private void initialize() {
        try {
            DWDeveloperServiceDefiner definer = new DWDeveloperServiceDefiner();
            Map<String, List<DWServiceInfo>> developerServices = definer.getDeveloperServices();
            this._services = developerServices;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh(String moduleName) throws Exception {
        this.initialize();
    }
}

