/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.AnnotaionUtils;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWParameterCastException;
import com.digiwin.app.service.AllowAnonymous;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DWMethod {
    private Method _method = null;
    protected Boolean _allowAnonymous = null;
    protected Annotation[] _methodAnnotations = null;

    public DWMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this._method = method;
    }

    public Method getMethod() {
        return this._method;
    }

    public String getMethodName() {
        return this._method.getName();
    }

    public boolean allowAnonymous() {
        if (this._allowAnonymous == null) {
            this._allowAnonymous = this._method.isAnnotationPresent(AllowAnonymous.class);
        }
        return this._allowAnonymous;
    }

    public boolean isMatch(DWParameters parameters) {
        return DWMethod.isMatch(this._method, parameters);
    }

    public static boolean isMatch(Method method, DWParameters parameters) {
        String[] parameterNames;
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        Parameter[] parameterList = method.getParameters();
        if (parameterList == null) {
            throw new IllegalStateException();
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (Parameter item : parameterList) {
            nameList.add(item.getName());
        }
        if (parameterList.length != parameters.getCount()) {
            return false;
        }
        for (String name : parameterNames = parameters.getNames()) {
            if (!nameList.contains(name)) {
                return false;
            }
            nameList.remove(name);
        }
        return true;
    }

    public Object invoke(Object service, DWParameters parameters) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (parameters == null) {
            throw new IllegalArgumentException();
        }
        Parameter[] parameterList = this._method.getParameters();
        if (parameterList == null) {
            throw new IllegalStateException();
        }
        Object[] invokeParameterList = new Object[parameterList.length];
        for (int i = 0; i < parameterList.length; ++i) {
            Object invokeParameter = null;
            try {
                invokeParameter = parameters.getValue(parameterList[i].getName(), parameterList[i].getType());
            }
            catch (Exception ex) {
                throw new DWParameterCastException(parameterList[i].getName(), parameterList[i].getType(), ex);
            }
            invokeParameterList[i] = invokeParameter;
        }
        this._methodAnnotations = this._method.getDeclaredAnnotations();
        if (!this._method.getName().equals("getModuleInfos")) {
            HashMap<String, Object> annotaionMap = new HashMap<String, Object>();
            annotaionMap.put("methodAnnotations", this._methodAnnotations);
            AnnotaionUtils.setAnnotation(annotaionMap);
        }
        return this._method.invoke(service, invokeParameterList);
    }

    public Map<String, Class<?>> getParameterInfo() {
        Parameter[] parameters;
        LinkedHashMap parameterInfo = new LinkedHashMap();
        for (Parameter parameter : parameters = this._method.getParameters()) {
            parameterInfo.put(parameter.getName(), parameter.getType());
        }
        return parameterInfo;
    }
}

