/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWQueryStringParameters;
import com.digiwin.app.service.restful.DWPathVariable;
import com.digiwin.app.service.restful.DWRequestBody;
import com.digiwin.app.service.restful.DWRequestBodyParam;
import com.digiwin.app.service.restful.DWRequestParam;
import com.digiwin.app.service.restful.DWRestfulRequest;
import java.lang.reflect.Parameter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DWRestfulParameters
extends DWDefaultParameters {
    private DWMethod method;
    private String body;
    private DWRestfulRequest restfulRequest;
    private DWQueryStringParameters requestParam;
    private DWDefaultParameters pathVariable;
    private DWDefaultParameters requestBody;

    public DWRestfulParameters(DWMethod method, HttpServletRequest request, DWRestfulRequest restfulRequest) {
        this.method = method;
        this.body = restfulRequest.getBodyAsString();
        this.restfulRequest = restfulRequest;
        this.initialize(request, restfulRequest.getPathVariable(), this.body);
    }

    private void initialize(HttpServletRequest request, Map<String, Object> pathVariableMap, String body) {
        this.requestParam = new DWQueryStringParameters(request);
        this.pathVariable = new DWDefaultParameters(pathVariableMap);
        this.requestBody = new DWDefaultParameters(body);
        super.putAll(this.pathVariable.getPararmeters());
        super.putAll(this.requestBody.getPararmeters());
        super.putAll(this.requestParam.getPararmeters());
    }

    @Override
    public Object getValue(String parameterName, Class<?> parameterType) throws Exception {
        if (DWRestfulRequest.class.isAssignableFrom(parameterType)) {
            return this.restfulRequest;
        }
        Parameter[] parameters = this.method.getMethod().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (!parameter.getName().equals(parameterName)) continue;
            if (parameter.isAnnotationPresent(DWRequestParam.class)) {
                Object value = this.requestParam.getValue(parameterName, parameterType);
                return value;
            }
            if (parameter.isAnnotationPresent(DWPathVariable.class)) {
                Object value = this.pathVariable.getValue(parameterName, parameterType);
                return value;
            }
            if (parameter.isAnnotationPresent(DWRequestBody.class)) {
                Object value = super.convertValueType(this.body, parameterType);
                return value;
            }
            if (!parameter.isAnnotationPresent(DWRequestBodyParam.class)) continue;
            Object value = this.requestBody.getValue(parameterName, parameterType);
            return value;
        }
        if (super.getPararmeters().containsKey(parameterName)) {
            Object value = super.getValue(parameterName, parameterType);
            return value;
        }
        Object value = super.convertValueType(this.body, parameterType);
        return value;
    }

    public DWRestfulRequest getRestfulRequest() {
        return this.restfulRequest;
    }

    public DWMethod getMethod() {
        return this.method;
    }
}

