/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWParameters;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DWDefaultParameters
extends DWParameters {
    private static final String KEY_IDEMPOTENT_ID = "$id";
    protected Map<String, Object> _parameters = new LinkedHashMap<String, Object>();

    public DWDefaultParameters() {
    }

    protected Gson getGson() {
        return DWGsonProvider.getGson();
    }

    public DWDefaultParameters(Map<String, Object> source) {
        this.putAll(source);
    }

    public DWDefaultParameters(String jsonString) {
        this.initialize(jsonString);
    }

    public void putAll(Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return;
        }
        this._parameters.putAll(sourceMap);
        this.initIdempotentId();
    }

    public void putAll(DWDefaultParameters parameters) {
        if (parameters == null) {
            return;
        }
        this._parameters.putAll(parameters._parameters);
    }

    public void put(String name, Object value) {
        this._parameters.put(name, value);
        this.initIdempotentId();
    }

    public Object remove(String name) {
        return this._parameters.remove(name);
    }

    @Override
    public Integer getCount() {
        return this._parameters.size();
    }

    @Override
    public String[] getNames() {
        String[] names = new String[this._parameters.size()];
        this._parameters.keySet().toArray(names);
        return names;
    }

    @Override
    public Object getValue(String parameterName, Class<?> parameterType) throws Exception {
        Object value = this._parameters.get(parameterName);
        return this.convertValueType(value, parameterType);
    }

    @Override
    public Object getValue(Parameter methodParameter) throws Exception {
        Object value = this._parameters.get(methodParameter.getName());
        return this.convertValueType(value, methodParameter.getType(), methodParameter.getParameterizedType());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("DWDefaultParameters@[");
        s.append(this._parameters.toString()).append("]");
        return s.toString();
    }

    protected void initialize(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return;
        }
        this._parameters = (Map)this.getGson().fromJson(jsonString, new TypeToken<LinkedHashMap<String, Object>>(){}.getType());
        if (this._parameters == null) {
            this._parameters = new LinkedHashMap<String, Object>();
        }
        this.initIdempotentId();
    }

    private void initIdempotentId() {
        if (this._parameters.containsKey(KEY_IDEMPOTENT_ID)) {
            Object id = this._parameters.remove(KEY_IDEMPOTENT_ID);
            if (id != null) {
                this.setIdempotentId(id.toString());
            } else {
                this.setIdempotentId(null);
            }
        }
    }

    protected Object convertValueType(Object value, Class<?> newType) throws Exception {
        return this.convertValueType(value, newType, null);
    }

    private boolean isAssignableFromMethodSignatureList(List<?> list, Type itemActualType) {
        if (list == null || list.size() == 0) {
            return true;
        }
        Object firstItem = list.get(0);
        boolean assignable = this.canPassGsonTypeCasting(firstItem, itemActualType);
        return assignable;
    }

    private boolean isAssignableFromMethodSignatureMap(Map<?, ?> map, Type keyActualType, Type valueActualType) {
        if (map == null || map.size() == 0) {
            return true;
        }
        Map.Entry<?, ?> item = map.entrySet().iterator().next();
        Object key = item.getKey();
        boolean keyAssignable = false;
        keyAssignable = this.canPassGsonTypeCasting(key, keyActualType);
        if (!keyAssignable) {
            return false;
        }
        Object value = item.getValue();
        boolean valueAssignable = this.canPassGsonTypeCasting(value, valueActualType);
        return valueAssignable;
    }

    private boolean isAssignableFromGenericType(Object value, ParameterizedType parameterizedType) {
        boolean assignable = false;
        Type rawType = parameterizedType.getRawType();
        if (rawType instanceof Class) {
            Class newClazz = (Class)rawType;
            if (!newClazz.isAssignableFrom(value.getClass())) {
                return false;
            }
            if (List.class.isAssignableFrom(newClazz)) {
                assignable = this.isAssignableFromMethodSignatureList((List)value, parameterizedType.getActualTypeArguments()[0]);
            } else if (Map.class.isAssignableFrom(newClazz)) {
                assignable = this.isAssignableFromMethodSignatureMap((Map)value, parameterizedType.getActualTypeArguments()[0], parameterizedType.getActualTypeArguments()[1]);
            }
        }
        return assignable;
    }

    private boolean canPassGsonTypeCasting(Object value, Type parameterType) {
        if (value == null) {
            return true;
        }
        boolean isAssignable = false;
        if (parameterType instanceof Class) {
            isAssignable = ((Class)parameterType).isAssignableFrom(value.getClass());
        } else if (parameterType instanceof ParameterizedType) {
            isAssignable = this.isAssignableFromGenericType(value, (ParameterizedType)parameterType);
        } else if (parameterType instanceof WildcardType) {
            isAssignable = true;
        }
        return isAssignable;
    }

    protected Object convertValueType(Object value, Class<?> newType, Type parameterType) throws Exception {
        String json;
        if (value == null) {
            if (newType.isPrimitive()) {
                throw new Exception("primitive type can not convert from null!");
            }
            return null;
        }
        if (this.canPassGsonTypeCasting(value, parameterType == null ? newType : parameterType)) {
            return value;
        }
        String string = json = value instanceof String ? value.toString() : this.getGson().toJson(value);
        if (newType == String.class) {
            return json;
        }
        Object newTypeValue = parameterType == null ? this.getGson().fromJson(json, newType) : this.getGson().fromJson(json, parameterType);
        return newTypeValue;
    }

    public Map<String, Object> getPararmeters() {
        return this._parameters;
    }
}

