/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container.restful;

import com.digiwin.app.container.DWMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class UrlNode {
    private DWMethod method = null;
    private String path = null;
    private boolean isPathVariable = false;
    private List<UrlNode> children = new ArrayList<UrlNode>();
    private UrlNode parent = null;

    public UrlNode(String path) {
        this.path = path;
    }

    public void addUrl(String path, DWMethod method) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] paths = path.split("/");
        UrlNode currentLevel = this;
        for (int i = 0; i < paths.length; ++i) {
            currentLevel = currentLevel.addChild(paths[i]);
        }
        currentLevel.setDWMethod(method);
    }

    public UrlNode addChild(String path) {
        for (UrlNode child : this.children) {
            if (!child.getPath().equals(path)) continue;
            return child;
        }
        UrlNode child = new UrlNode(path);
        child.setParent(this);
        if (Pattern.compile("\\{(.*?)\\}").matcher(path).matches()) {
            child.setPathVariable(true);
        }
        this.children.add(child);
        return child;
    }

    public List<UrlNode> getChildren() {
        return this.children;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    private void setParent(UrlNode parent) {
        this.parent = parent;
    }

    public UrlNode getParent() {
        return this.parent;
    }

    public DWMethod getDWMethod() {
        return this.method;
    }

    public void setDWMethod(DWMethod method) {
        this.method = method;
    }

    public boolean isPathVariable() {
        return this.isPathVariable;
    }

    public void setPathVariable(boolean isPathVariable) {
        this.isPathVariable = isPathVariable;
    }
}

