/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import java.lang.reflect.Parameter;
import java.util.ArrayList;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicePublicMethodLogInterceptor
implements MethodInterceptor {
    private static Log log = LogFactory.getLog(ServicePublicMethodLogInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = null;
        long invokeTimestamp = this.log(invocation);
        try {
            result = invocation.proceed();
            this.logResult(invokeTimestamp, result);
        }
        catch (Throwable e) {
            this.logException(invokeTimestamp, e);
            throw e;
        }
        return result;
    }

    private long log(MethodInvocation invocation) {
        String stringInfo = invocation == null ? "unknown" : invocation.toString();
        String[] partsInfo = stringInfo.split(" ");
        String serviceMethodSignature = partsInfo.length > 4 ? partsInfo[3] : invocation.getMethod().getName();
        int leftBraces = serviceMethodSignature.indexOf("(");
        if (leftBraces != -1) {
            serviceMethodSignature = serviceMethodSignature.substring(0, leftBraces);
        }
        Parameter[] parameters = invocation.getMethod().getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            parameterNames.add(parameters[i].getName());
        }
        serviceMethodSignature = serviceMethodSignature + "(" + StringUtils.join((Object[])parameterNames.toArray(), (String)",") + ")";
        StringBuilder message = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        message.append("io>").append("invoke[").append(timestamp).append("]").append("{").append(threadId).append("}").append(">").append(serviceMethodSignature);
        message.append(" input: (");
        Object[] arguments = invocation.getArguments();
        if (arguments == null) {
            message.append(arguments);
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                if (i != 0) {
                    message.append(", ");
                }
                if (arguments[i] == null) {
                    message.append("null");
                    continue;
                }
                message.append(arguments[i]);
            }
        }
        message.append(")");
        log.info((Object)message.toString());
        return timestamp;
    }

    private void logResult(long invokeTimestamp, Object result) throws Exception {
        StringBuffer resultMessage = new StringBuffer();
        long threadId = Thread.currentThread().getId();
        resultMessage.append("io>result[").append(invokeTimestamp).append("]").append("{").append(threadId).append("}").append(">").append(result);
        log.info((Object)resultMessage.toString());
    }

    private void logException(long invokeTimestamp, Throwable e) throws Exception {
        StringBuffer exceptionMessage = new StringBuffer();
        long threadId = Thread.currentThread().getId();
        exceptionMessage.append("io>exception[").append(invokeTimestamp).append("]").append("{").append(threadId).append("}").append(">");
        log.error((Object)exceptionMessage.toString(), e);
    }
}

