/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceLocationInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DWHeaderRepositoryList
implements DWHeaderRepository {
    private List<DWHeaderRepository> _repositoryList = new ArrayList<DWHeaderRepository>();

    public void setRepositories(List<DWHeaderRepository> repositories) {
        this._repositoryList = repositories;
    }

    public void addRepository(DWHeaderRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this._repositoryList.add(repository);
    }

    @Override
    public List<DWHeader> getAllHeader() {
        ArrayList<DWHeader> resultList = new ArrayList<DWHeader>();
        for (DWHeaderRepository repository : this._repositoryList) {
            List<DWHeader> headerList = repository.getAllHeader();
            if (headerList == null) continue;
            resultList.addAll(headerList);
        }
        return resultList;
    }

    @Override
    public List<DWHeader> getHeaders(String moduleName) {
        ArrayList<DWHeader> resultList = new ArrayList<DWHeader>();
        for (DWHeaderRepository repository : this._repositoryList) {
            List<DWHeader> headerList = repository.getHeaders(moduleName);
            if (headerList == null) continue;
            resultList.addAll(headerList);
        }
        return resultList;
    }

    @Override
    public DWHeader getHeader(String groupName, String serviceName) {
        for (DWHeaderRepository repository : this._repositoryList) {
            DWHeader header = repository.getHeader(groupName, serviceName);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    @Override
    public DWTargetAPI getAPI(DWServiceLocationInfo locationInfo) {
        DWHeaderRepository h;
        DWTargetAPI api = null;
        Iterator<DWHeaderRepository> iterator = this._repositoryList.iterator();
        while (iterator.hasNext() && !DWTargetAPI.isValid(api = (h = iterator.next()).getAPI(locationInfo))) {
        }
        return api;
    }

    @Override
    public void refresh(String groupName) throws Exception {
        for (DWHeaderRepository repository : this._repositoryList) {
            repository.refresh(groupName);
        }
    }
}

