/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.log.operation.annotation.DWIgnoreFileLog;
import com.digiwin.app.log.operation.annotation.DWLogOperation;
import com.digiwin.app.log.operation.config.DWLogOperationProperties;
import com.digiwin.app.log.operation.dao.ILogOperationDao;
import com.digiwin.app.log.operation.vo.DWLogOperationCollection;
import com.digiwin.app.log.operation.vo.DWLogOperationErrorVo;
import com.digiwin.app.log.operation.vo.DWLogOperationServiceVo;
import com.digiwin.app.log.operation.vo.DWLogOperationSqlVo;
import com.digiwin.app.log.operation.vo.IDWLogOperationVo;
import com.digiwin.app.log.utils.DWLogUtils;
import com.digiwin.app.service.DWServiceContext;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServicePublicMethodLogInterceptor
implements MethodInterceptor {
    private static Log log = LogFactory.getLog(ServicePublicMethodLogInterceptor.class);
    @Autowired(required=false)
    @Qualifier(value="dw-log-operation-configuration")
    private DWLogOperationProperties operateLogProperties;
    @Autowired(required=false)
    @Qualifier(value="dw-log-operation-dao")
    private ILogOperationDao dwLogRecordDao;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = null;
        boolean fileLogFlag = this.getFileLogFlag(invocation);
        long invokeTimestamp = System.currentTimeMillis();
        if (fileLogFlag) {
            invokeTimestamp = this.log(invocation);
        }
        boolean isLogOperationEnabled = this.checkLogOperationEnabled(invocation);
        try {
            result = invocation.proceed();
            if (fileLogFlag) {
                this.logResult(invokeTimestamp, result);
            }
        }
        catch (Throwable e) {
            if (fileLogFlag) {
                this.logException(invokeTimestamp, e);
            }
            if (isLogOperationEnabled) {
                this.writeOperateLogError(invocation, invokeTimestamp, e);
            }
            this.logDistributedTransactionId();
            throw e;
        }
        this.logDistributedTransactionId();
        if (isLogOperationEnabled) {
            this.writeOperateLog(invocation, invokeTimestamp, result);
        }
        return result;
    }

    private long log(MethodInvocation invocation) {
        String stringInfo = invocation == null ? "unknown" : invocation.toString();
        String[] partsInfo = stringInfo.split(" ");
        String serviceMethodSignature = partsInfo.length > 4 ? partsInfo[3] : invocation.getMethod().getName();
        int leftBraces = serviceMethodSignature.indexOf("(");
        if (leftBraces != -1) {
            serviceMethodSignature = serviceMethodSignature.substring(0, leftBraces);
        }
        Parameter[] parameters = invocation.getMethod().getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            parameterNames.add(parameters[i].getName());
        }
        serviceMethodSignature = serviceMethodSignature + "(" + StringUtils.join((Object[])parameterNames.toArray(), (String)",") + ")";
        StringBuilder message = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        message.append("io>").append("invoke[").append(timestamp).append("]").append("{").append(threadId).append("}").append(">").append(serviceMethodSignature);
        message.append(" input: (");
        Object[] arguments = invocation.getArguments();
        if (arguments == null) {
            message.append(arguments);
        } else {
            for (int i = 0; i < arguments.length; ++i) {
                if (i != 0) {
                    message.append(", ");
                }
                if (arguments[i] == null) {
                    message.append("null");
                    continue;
                }
                message.append(arguments[i]);
            }
        }
        message.append(")");
        log.info((Object)message.toString());
        return timestamp;
    }

    private void logResult(long invokeTimestamp, Object result) throws Exception {
        StringBuffer resultMessage = new StringBuffer();
        long threadId = Thread.currentThread().getId();
        resultMessage.append("io>result[").append(invokeTimestamp).append("]").append("{").append(threadId).append("}").append(">").append(result);
        log.info((Object)resultMessage.toString());
    }

    private void logException(long invokeTimestamp, Throwable e) throws Exception {
        StringBuffer exceptionMessage = new StringBuffer();
        long threadId = Thread.currentThread().getId();
        exceptionMessage.append("io>exception[").append(invokeTimestamp).append("]").append("{").append(threadId).append("}").append(">");
        log.error((Object)exceptionMessage.toString(), e);
    }

    private void writeOperateLog(MethodInvocation invocation, long invokeTimestampBefore, Object result) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.operateLogProperties == null || !this.operateLogProperties.isEnabled()) {
            return;
        }
        try {
            long timestampAfter = System.currentTimeMillis();
            long timeConsume = timestampAfter - invokeTimestampBefore;
            DWLogOperationServiceVo dwLogOperationVo = new DWLogOperationServiceVo(invocation, timeConsume, result);
            dwLogOperationVo.setOperateLogProperties(this.operateLogProperties);
            DWLogOperationCollection logVoCollection = new DWLogOperationCollection();
            logVoCollection.addVo((IDWLogOperationVo)dwLogOperationVo);
            String serviceOpLogId = dwLogOperationVo.getOpMainLogId();
            Method method = invocation.getMethod();
            DWLogOperation dwLogOperationAnnotation = method.getAnnotation(DWLogOperation.class);
            if (this.operateLogProperties.isLogSqlEnabled() && dwLogOperationAnnotation.logSql() && StringUtils.isNotEmpty((CharSequence)serviceOpLogId)) {
                DWLogOperationSqlVo dwLogOperationSqlVo = new DWLogOperationSqlVo(serviceOpLogId);
                logVoCollection.addVo((IDWLogOperationVo)dwLogOperationSqlVo);
            }
            this.dwLogRecordDao.writeLogOperation(logVoCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeOperateLogError(MethodInvocation invocation, long invokeTimestampBefore, Throwable result) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (this.operateLogProperties == null || !this.operateLogProperties.isEnabled() || !this.operateLogProperties.isLogErrorEnabled()) {
            return;
        }
        try {
            long timestampAfter = System.currentTimeMillis();
            long timeConsume = timestampAfter - invokeTimestampBefore;
            DWLogOperationErrorVo dwLogOperationVo = new DWLogOperationErrorVo(invocation, timeConsume, result);
            dwLogOperationVo.setOperateLogProperties(this.operateLogProperties);
            DWLogOperationCollection logVoCollection = new DWLogOperationCollection();
            logVoCollection.addVo((IDWLogOperationVo)dwLogOperationVo);
            this.dwLogRecordDao.writeLogOperation(logVoCollection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkLogOperationEnabled(MethodInvocation invocation) {
        boolean isLogOperationEnabled = false;
        Method method = invocation.getMethod();
        DWLogOperation dwLogOperationAnnotation = method.getAnnotation(DWLogOperation.class);
        if (dwLogOperationAnnotation != null && this.operateLogProperties != null) {
            this.generateLogOperationProfile(dwLogOperationAnnotation);
            isLogOperationEnabled = true;
        }
        return isLogOperationEnabled;
    }

    private void generateLogOperationProfile(DWLogOperation dwLogOperationAnnotation) {
        Objects.requireNonNull(dwLogOperationAnnotation, "dwLogOperationAnnotation is required");
        Objects.requireNonNull(this.operateLogProperties, "ServicePublicMethodLogInterceptor.operateLogProperties is required");
        if (this.operateLogProperties.isEnabled()) {
            Map logRecord = DWServiceContext.getContext().getOperateLog();
            logRecord.put("isLogRecord", this.operateLogProperties.isEnabled());
            logRecord.put("isLogSqlRecord", this.getCombinedBoolean("isLogSqlRecord", this.operateLogProperties.isLogSqlEnabled(), dwLogOperationAnnotation.logSql()));
            logRecord.put("isLogErrorRecord", this.getCombinedBoolean("isLogErrorRecord", this.operateLogProperties.isLogErrorEnabled(), dwLogOperationAnnotation.logError()));
            logRecord.put("operateStatus", 1);
        } else {
            Map logRecord = DWServiceContext.getContext().getOperateLog();
            logRecord.put("isLogRecord", false);
            logRecord.put("isLogSqlRecord", false);
            logRecord.put("isLogErrorRecord", false);
            logRecord.put("operateStatus", 1);
        }
    }

    private boolean getCombinedBoolean(String property, boolean topLevel, boolean secondLevel) {
        boolean returnValue = false;
        returnValue = topLevel ? secondLevel : topLevel;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("[%s] vaule=%b (properties:%b, annotation:%b)", property, returnValue, topLevel, secondLevel));
        }
        return returnValue;
    }

    private void logDistributedTransactionId() {
        String xid = DWLogUtils.getDistributedTransactionId();
        if (StringUtils.isNotEmpty((CharSequence)xid)) {
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            ((ServletRequestAttributes)requestAttributes).getResponse().addHeader("TX_XID", xid);
        }
    }

    private boolean getFileLogFlag(MethodInvocation invocation) {
        DWIgnoreFileLog classAnnotation = invocation.getThis().getClass().getAnnotation(DWIgnoreFileLog.class);
        DWIgnoreFileLog methodAnnotation = invocation.getMethod().getAnnotation(DWIgnoreFileLog.class);
        return null == classAnnotation && null == methodAnnotation;
    }
}

