/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWHeaderRegistry;
import com.digiwin.app.container.DWHeaderRepository;
import com.digiwin.app.container.DWMethodMatchProcessor;
import com.digiwin.app.container.DWTargetAPI;
import com.digiwin.app.service.DWServiceLocationInfo;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWAbstractHeaderRepository<H extends DWHeader, L extends DWServiceLocationInfo>
implements DWHeaderRepository,
DWHeaderRegistry<H> {
    protected static Log log = LogFactory.getLog(DWAbstractHeaderRepository.class);
    private Class<L> acceptableLocationInfoClass;
    protected Map<String, List<H>> _headers = new HashMap<String, List<H>>();
    protected List<DWMethodMatchProcessor> _matchProcessors = new ArrayList<DWMethodMatchProcessor>();

    public DWAbstractHeaderRepository() {
        this.acceptableLocationInfoClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    }

    @Override
    public List<DWHeader> getAllHeader() {
        return this._headers.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<DWHeader> getHeaders(String groupName) {
        List<DWHeader> groupHeaders = this._headers.get(groupName);
        if (groupHeaders == null) {
            return Collections.emptyList();
        }
        return groupHeaders;
    }

    @Override
    public DWHeader getHeader(String groupName, String serviceName) {
        List<H> groupHeaders = this._headers.get(groupName);
        if (groupHeaders == null) {
            return null;
        }
        return groupHeaders.stream().filter(h -> h.getServiceName().equals(serviceName)).findFirst().orElse(null);
    }

    @Override
    public DWTargetAPI getAPI(DWServiceLocationInfo locationInfo) {
        if (this.accept(locationInfo)) {
            return this.searchAPI(locationInfo);
        }
        return null;
    }

    protected boolean accept(DWServiceLocationInfo locationInfo) {
        return this.acceptableLocationInfoClass.isInstance(locationInfo);
    }

    protected abstract DWTargetAPI searchAPI(L var1);

    @Override
    public void register(Map<String, List<H>> headers) {
        Objects.requireNonNull(headers);
        headers.forEach(this::register);
    }

    @Override
    public void register(String groupName, List<H> headers) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("groupName is null or empty!");
        }
        if (headers == null) {
            headers = Collections.emptyList();
        }
        List<H> oldHeaders = null;
        if (this._headers.containsKey(groupName)) {
            oldHeaders = this._headers.remove(groupName);
            log.warn((Object)String.format("! Register %s, group name=%s is exist, header count=%s, old headers will be overridden!", this.getClass().getSimpleName(), groupName, oldHeaders.size()));
        }
        if (headers.size() > 0 || oldHeaders != null) {
            log.info((Object)String.format("> Register %s, group name=%s, header count=%s", this.getClass().getSimpleName(), groupName, headers.size()));
        }
        if (headers.size() > 0) {
            this._headers.put(groupName, headers);
        }
        this.afterRegister(groupName, headers, oldHeaders);
    }

    protected abstract void afterRegister(String var1, List<H> var2, List<H> var3);

    @Override
    public void refresh(String moduleName) {
    }

    public List<DWMethodMatchProcessor> getMatchProcessors() {
        return this._matchProcessors;
    }

    public void addMatchProcessor(DWMethodMatchProcessor matchProcessor) {
        this._matchProcessors.add(matchProcessor);
    }
}

