/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWMethodNotFoundException;
import com.digiwin.app.container.exceptions.DWServiceNotFoundException;
import com.digiwin.app.module.DWServiceInfo;
import com.digiwin.app.service.DWService;
import java.lang.reflect.Method;

public class DWCrossModuleServiceInvoker {
    DWCrossModuleServiceInvoker() {
    }

    public static Object invoke(Object sourceDao, String moduleName, String serviceName, String methodName, DWDefaultParameters parameters) throws Exception {
        Object result = null;
        DWServiceInfo serviceInfo = DWContainerContext.getInstance().getServiceInfo(moduleName, serviceName);
        if (serviceInfo == null) {
            throw new DWServiceNotFoundException(moduleName, serviceName);
        }
        DWService serviceInstance = serviceInfo.getInstance();
        Class implementType = serviceInfo.getImplementationType();
        boolean isMockService = false;
        if (implementType.isAssignableFrom(serviceInstance.getClass())) {
            parameters.put("targetDao", sourceDao);
        } else {
            isMockService = true;
            implementType = serviceInfo.getInterfaceType();
        }
        DWMethod targetMethod = DWCrossModuleServiceInvoker.getServiceTargetMethod(implementType, serviceInstance, methodName, parameters);
        if (targetMethod == null) {
            throw new DWMethodNotFoundException(moduleName, serviceName, methodName, parameters);
        }
        result = targetMethod.invoke(serviceInstance, parameters);
        if (isMockService) {
            throw new Exception("Mock Service is not correct, throw exception must be executed!");
        }
        return result;
    }

    private static DWMethod getServiceTargetMethod(Class<?> implementType, Object serviceInstance, String methodName, DWParameters parameters) {
        Method[] methodList = implementType.getMethods();
        if (methodList == null) {
            throw new IllegalStateException();
        }
        DWMethod methodInfo = null;
        for (Method method : methodList) {
            if (!methodName.equals(method.getName())) continue;
            methodInfo = new DWMethod(method);
            if (methodInfo.isMatch(parameters)) break;
            methodInfo = null;
        }
        return methodInfo;
    }
}

