/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.container;

import com.digiwin.app.container.DWHeader;
import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.DWServiceInvocationProcessor;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceLocationInfo;

public class DWGroupServiceInvocationProcessor
implements DWServiceInvocationProcessor {
    private static ThreadLocal<String> _currentGroupName = new ThreadLocal();

    @Override
    public void beforeInvoke(DWServiceLocationInfo locationInfo) {
        String moduleName = DWServiceContext.getContext().getGroupName();
        _currentGroupName.set(moduleName == null ? locationInfo.getGroup() : moduleName);
    }

    @Override
    public void onInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWServiceContext.getContext().setGroupName(locationInfo.getGroup());
    }

    @Override
    public void afterInvoke(DWMethod method, Object service, DWServiceLocationInfo locationInfo) {
        DWServiceContext.getContext().setGroupName(_currentGroupName.get());
    }

    @Override
    public void beforeInvoke(DWHeader header, DWMethod method) {
        String groupName = DWServiceContext.getContext().getGroupName();
        if (groupName == null) {
            groupName = header.getModuleName();
        }
        DWServiceContext.getContext().setGroupName(groupName);
        _currentGroupName.set(groupName);
    }

    @Override
    public void onInvoke(DWHeader header, DWMethod method, Object service) {
        DWServiceContext.getContext().setGroupName(header.getModuleName());
    }

    @Override
    public void afterInvoke(DWHeader header, DWMethod method, Object service) {
        DWServiceContext.getContext().setGroupName(_currentGroupName.get());
    }
}

