/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import java.util.List;
import java.util.Map;

public final class DWQueryInfoBuilder {
    private String primaryKeyName;
    private List<Object> oids;

    public static DWQueryInfo create(List<Object> oids) {
        DWQueryInfoBuilder builder = new DWQueryInfoBuilder();
        builder.setOids(oids);
        return builder.create();
    }

    public DWQueryInfo create() {
        DWQueryInfo queryInfo = new DWQueryInfo();
        if (this.oids == null) {
            return queryInfo;
        }
        queryInfo.getCondition().ORJoin();
        this.oids.stream().forEach(oid -> {
            DWQueryCondition condition = new DWQueryCondition();
            if (oid instanceof Map) {
                Map mapOid = (Map)oid;
                for (Map.Entry item : mapOid.entrySet()) {
                    condition.addEqualInfo((String)item.getKey(), item.getValue());
                }
            } else {
                if (this.primaryKeyName == null || this.primaryKeyName.isEmpty()) {
                    throw new IllegalArgumentException("oid is not Map, so primaryKeyName can not be null or empty!");
                }
                condition.addEqualInfo(this.primaryKeyName, oid);
            }
            queryInfo.getCondition().addCondition(condition);
        });
        return queryInfo;
    }

    public DWQueryInfoBuilder setOids(List<Object> oids) {
        this.oids = oids;
        return this;
    }

    public DWQueryInfoBuilder setPrimaryKeyName(String name) {
        this.primaryKeyName = name;
        return this;
    }
}

