/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWCascadeDeletingInfo;
import com.digiwin.app.data.DWCascadeQueryInfo;
import com.digiwin.app.data.DWDataSetInsertOption;
import com.digiwin.app.data.DWDataTableStatementOption;
import com.digiwin.utils.DWTenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DWDataSetOperationOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DWDataSetInsertOption insertOption = null;
    private List<DWCascadeQueryInfo> cascadeQueries = new ArrayList<DWCascadeQueryInfo>();
    private List<DWCascadeDeletingInfo> cascadeDeletings = new ArrayList<DWCascadeDeletingInfo>();
    private DWDataTableStatementOption option = null;
    private boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private boolean relatedTableTenantEnabled = DWTenantUtils.isTenantenabled();
    private String sqlOrderTypeOfExecution = null;

    public DWDataSetOperationOption setSqlOrderTypeOfExecution(String orderType) {
        this.sqlOrderTypeOfExecution = orderType;
        return this;
    }

    public String getSqlOrderTypeOfExecution() {
        return this.sqlOrderTypeOfExecution;
    }

    public DWDataSetOperationOption setInsertOperation(DWDataSetInsertOption insertOption) {
        this.insertOption = insertOption;
        return this;
    }

    public DWDataSetInsertOption getInsertOption() {
        if (this.insertOption == null) {
            this.insertOption = new DWDataSetInsertOption();
        }
        return this.insertOption;
    }

    public DWCascadeQueryInfo addCascadeQuery(String referenceTableName) {
        return this.addCascadeQuery(null, referenceTableName);
    }

    public DWCascadeQueryInfo addCascadeQuery(String primaryTableName, String referenceTableName) {
        DWCascadeQueryInfo queryInfo = new DWCascadeQueryInfo(primaryTableName, referenceTableName);
        this.cascadeQueries.add(queryInfo);
        return queryInfo;
    }

    public DWCascadeDeletingInfo addCascadeDeleting(String referenceTableName) {
        return this.addCascadeDeleting(null, referenceTableName);
    }

    public DWCascadeDeletingInfo addCascadeDeleting(String primaryTableName, String referenceTableName) {
        DWCascadeDeletingInfo deletingInfo = new DWCascadeDeletingInfo(primaryTableName, referenceTableName);
        this.cascadeDeletings.add(deletingInfo);
        return deletingInfo;
    }

    public List<DWCascadeQueryInfo> getCascadingQueryList() {
        return this.cascadeQueries;
    }

    public List<DWCascadeDeletingInfo> getCascadingDeletingList() {
        return this.cascadeDeletings;
    }

    public boolean isTenantEnabled() {
        return this.tenantEnabled;
    }

    public void setTenantEnabled(boolean tenantEnabled) {
        this.tenantEnabled = tenantEnabled;
    }

    public boolean isRelatedTableTenantEnabled() {
        return this.relatedTableTenantEnabled;
    }

    public void setRelatedTableTenantEnabled(boolean relatedTableTenantEnabled) {
        this.relatedTableTenantEnabled = relatedTableTenantEnabled;
    }

    private DWDataTableStatementOption getDefaultOption() {
        return this.option;
    }

    public DWDataTableStatementOption getTableStatementOption() {
        DWDataTableStatementOption option = this.getDefaultOption();
        if (option == null) {
            option = this.option = new DWDataTableStatementOption();
        }
        return option;
    }
}

