/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataColumnCollection;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTableCollection;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.exceptions.DWMetadataNotFoundException;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DWDataTable
implements Serializable {
    public static final String NAME_UNASSIGNED = "$unassigned";
    private String name;
    private transient DWDataTableCollection owner;
    private DWDataColumnCollection columns;
    private DWDataRowCollection rows = new DWDataRowCollection(this);

    public DWDataTable() {
    }

    public DWDataTable(String name) {
        this.name = name;
    }

    private void initDataColumns() {
        this.columns = new DWDataColumnCollection(this);
        try {
            DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)this.name, DWRdbmsMetadata.class);
            List fieldNames = metadata.getFields().stream().map(f -> f.getName()).collect(Collectors.toList());
            this.columns.add((String[])fieldNames.stream().toArray(String[]::new));
        }
        catch (DWMetadataNotFoundException dWMetadataNotFoundException) {
            // empty catch block
        }
    }

    public void setName(String newName) {
        if (this.owner != null) {
            this.owner.onTableRename(this, newName);
        }
        this.name = newName;
    }

    public String getName() {
        if (this.name == null || this.name.isEmpty()) {
            this.name = NAME_UNASSIGNED;
        }
        return this.name;
    }

    protected void setOwner(DWDataTableCollection owner) {
        this.owner = owner;
    }

    protected DWDataTableCollection getOwner() {
        return this.owner;
    }

    public DWDataSet getDataSet() {
        return this.getOwner().getOwner();
    }

    public DWDataRowCollection getRows() {
        this.rows.setOwner(this);
        return this.rows;
    }

    public DWDataRow getRow(int index) {
        return this.getRows().get(index);
    }

    public DWDataColumnCollection getColumns() {
        if (this.columns == null) {
            this.initDataColumns();
        }
        return this.columns;
    }

    public DWDataRow newRow() {
        DWDataRow row = this.rows.newRow();
        return row;
    }

    public DWDataRow newRow(Map<String, Object> orgData) {
        DWDataRow row = this.rows.newRow();
        row.importOrgData(orgData);
        return row;
    }

    public DWDataRow[] newRows(List<Map<String, Object>> orgDatas) {
        DWDataRow[] rows = new DWDataRow[orgDatas.size()];
        int i = 0;
        for (Map<String, Object> orgData : orgDatas) {
            DWDataRow row = this.newRow(orgData);
            rows[i++] = row;
        }
        return rows;
    }
}

