/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

public class SQLParser {
    public static final String INSERT_SQL_PREFIX = "insert into ";
    public static final String INSERT_SQL_POSTFIX = "(";
    public static final int INSERT_SQL_PREFIX_INDEX = "insert into ".length();
    public static final String UPDATE_SQL_PREFIX = "update ";
    public static final String UPDATE_SQL_POSTFIX = "set ";
    public static final int UPDATE_SQL_PREFIX_INDEX = "update ".length();
    public static final String DELETE_SQL_PREFIX = "delete from ";
    public static final String DELETE_SQL_POSTFIX = "where ";
    public static final int DELETE_SQL_PREFIX_INDEX = "delete from ".length();
    public static final String SELECT_SQL_PREFIX1 = "select ";
    public static final String SELECT_SQL_PREFIX2 = "from ";
    public static final String SELECT_SQL_POSTFIX = "where ";
    public static final int SELECT_SQL_PREFIX_INDEX = "from ".length();

    public static String fetchTableName(String sql) throws Exception {
        String result = "";
        String targetSql = sql.toLowerCase();
        if (targetSql.indexOf(INSERT_SQL_PREFIX) > -1) {
            int leftIndex = targetSql.indexOf(INSERT_SQL_PREFIX) + INSERT_SQL_PREFIX_INDEX;
            int rightIndex = targetSql.indexOf(INSERT_SQL_POSTFIX);
            result = sql.substring(leftIndex, rightIndex);
        } else if (targetSql.indexOf(UPDATE_SQL_PREFIX) > -1) {
            int leftIndex = targetSql.indexOf(UPDATE_SQL_PREFIX) + UPDATE_SQL_PREFIX_INDEX;
            int rightIndex = targetSql.indexOf(UPDATE_SQL_POSTFIX);
            result = sql.substring(leftIndex, rightIndex);
        } else if (targetSql.indexOf(DELETE_SQL_PREFIX) > -1) {
            int leftIndex = targetSql.indexOf(DELETE_SQL_PREFIX) + DELETE_SQL_PREFIX_INDEX;
            int rightIndex = targetSql.indexOf("where ");
            result = sql.substring(leftIndex, rightIndex);
        } else if (targetSql.indexOf(SELECT_SQL_PREFIX1) > -1) {
            int leftIndex = targetSql.indexOf(SELECT_SQL_PREFIX2) + SELECT_SQL_PREFIX_INDEX;
            int rightIndex = targetSql.indexOf("where ");
            result = sql.substring(leftIndex, rightIndex);
        }
        result = result.replace("\n", "").replace("\t", "").trim();
        return result;
    }

    public static void main(String[] args) throws Exception {
        String insertSQL = SQLParser.getInsertSQL();
        System.out.println("insert sql table name:" + SQLParser.fetchTableName(insertSQL));
        String updateSQL = SQLParser.getUpdateSQL();
        System.out.println("updateSQL sql table name:" + SQLParser.fetchTableName(updateSQL));
        String deleteSQL = SQLParser.getDeleteSQL();
        System.out.println("deleteSQL sql table name:" + SQLParser.fetchTableName(deleteSQL));
        String selectSQL = SQLParser.getSelectSQL();
        System.out.println("selectSQL sql table name:" + SQLParser.fetchTableName(selectSQL));
    }

    public static String getInsertSQL() {
        String sql = "Query is: INSERT INTO STUDENTS1( STUD_ID,EMAIL,NAME,DOB,AGE )VALUES( ?,?,?,?,? )";
        return sql;
    }

    public static String getUpdateSQL() {
        String sql = "Query is: UPDATE STUDENTS2 SET STUD_ID = ?, EMAIL = ? WHERE 1=1 AND ID = ?";
        return sql;
    }

    public static String getDeleteSQL() {
        String sql = "Query is: DELETE FROM STUDENTS3 WHERE 1=1";
        return sql;
    }

    public static String getSelectSQL() {
        String sql = "Query is: SELECT STUD_ID, EMAIL FROM STUDENTS4 WHERE 1=1";
        return sql;
    }
}

