/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiTenancyInterceptor
implements MethodInterceptor {
    private static Log log = LogFactory.getLog(MultiTenancyInterceptor.class);
    private static boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private static String tenantColumnName = DWTenantUtils.getTenantColumnName();
    private static String IAM_TENANTSIDKEY = DWTenantUtils.getIAMTenantSidKey();
    private static String sqlTenantTag = DWTenantUtils.getTenantTagByColumnName();
    private static String sqlTenantNameTag = DWTenantUtils.getSqlTenantNameTag();
    private static String sqlTenantValueTag = DWTenantUtils.getSqlTenantValueTag();
    private static String sqlIgnoreTenantTag = DWTenantUtils.getTenantIgnoreTagByColumnName();
    private static String sqlIgnoreTenantNameTag = DWTenantUtils.getSqlIgnoreTenantNameTag();
    private static String sqlIgnoreTenantValueTag = DWTenantUtils.getSqlIgnoreTenantValueTag();
    private static final String _matchQuoteEmpty = Matcher.quoteReplacement(" ");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object[] args = invocation.getArguments();
        String sqlcommand = (String)args[0];
        log.debug((Object)("[MultiTenancyInterceptor] TenantEnabled:" + tenantEnabled + ",before sql command:" + sqlcommand));
        if (tenantEnabled) {
            Map profile = DWServiceContext.getContext().getProfile();
            if (!profile.containsKey(IAM_TENANTSIDKEY)) throw new DWDataException("13012", String.format("[MultiTenancyInterceptor] %s is missing in profile.", tenantColumnName));
            Long tenantSid = (Long)profile.get(IAM_TENANTSIDKEY);
            if (!sqlcommand.contains(sqlTenantTag) && !sqlcommand.contains(sqlTenantNameTag) && !sqlcommand.contains(sqlTenantValueTag)) throw new DWDataException("13014", String.format("[MultiTenancyInterceptor] related tenant tag(%s/%s/%s) is missing in sqlcommand.", sqlTenantTag, sqlTenantNameTag, sqlTenantValueTag));
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantTag), _matchQuoteEmpty);
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantNameTag), _matchQuoteEmpty);
            if ((sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantValueTag), _matchQuoteEmpty)).contains(sqlTenantTag)) {
                sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantTag), Matcher.quoteReplacement(" and " + tenantColumnName + "= " + tenantSid + " "));
            }
            if (sqlcommand.contains(sqlTenantNameTag)) {
                sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantNameTag), Matcher.quoteReplacement(", " + tenantColumnName));
            }
            if (sqlcommand.contains(sqlTenantValueTag)) {
                sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantValueTag), Matcher.quoteReplacement(", " + tenantSid + " "));
            }
            args[0] = sqlcommand;
            log.debug((Object)("[MultiTenancyInterceptor] after sql command:" + sqlcommand));
            return invocation.proceed();
        } else {
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantTag), _matchQuoteEmpty);
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantNameTag), _matchQuoteEmpty);
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantValueTag), _matchQuoteEmpty);
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantTag), _matchQuoteEmpty);
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantNameTag), _matchQuoteEmpty);
            sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantValueTag), _matchQuoteEmpty);
            args[0] = sqlcommand;
            log.debug((Object)("[MultiTenancyInterceptor][non-tenant] after sql command:" + sqlcommand));
        }
        return invocation.proceed();
    }
}

