/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.dialect;

import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.dao.DWDataSetSqlInfo;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryElement;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.data.DWAutoIncrementOption;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataRowState;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DWCommonSQLDialect
implements DWSQLDialect {
    private static Log log = LogFactory.getLog(DWCommonSQLDialect.class);
    private static boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private static String tenantColumnName = DWTenantUtils.getTenantColumnName();
    private static String IAM_TENANTSID = DWTenantUtils.getIAMTenantSidKey();

    protected abstract void attachPageSQLInfo(StringBuilder var1, List<Object> var2, int var3, int var4);

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo pagableQueryInfo) {
        return this.parseCount(pagableQueryInfo, null, null);
    }

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo pagableQueryInfo, DWDataSetOperationOption option) {
        return this.parseCount(pagableQueryInfo, null, option);
    }

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo pagableQueryInfo, String sql) {
        return this.parseCount(pagableQueryInfo, sql, null);
    }

    private DWDataSetOperationOption createDefaultOption() {
        DWDataSetOperationOption defaultOption = new DWDataSetOperationOption();
        defaultOption.setTenantEnabled(tenantEnabled);
        defaultOption.setRelatedTableTenantEnabled(tenantEnabled);
        return defaultOption;
    }

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo pagableQueryInfo, String sql, DWDataSetOperationOption option) {
        if (option == null) {
            option = this.createDefaultOption();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> parameters = new ArrayList<Object>();
        String subSql = StringUtils.isBlank((CharSequence)sql) ? "FROM " + pagableQueryInfo.getTableName() : sql.substring(sql.toUpperCase().indexOf(" FROM ") + 1);
        DWQueryCondition additionalCondition = this.addSystemCondition(pagableQueryInfo, option);
        pagableQueryInfo.setCondition(additionalCondition);
        if (pagableQueryInfo.isDistinct()) {
            if (null == pagableQueryInfo.getSelectFields() || pagableQueryInfo.getSelectFields().size() <= 0) {
                throw new DWDataException("13007", "selectFields cannot be null");
            }
            sqlBuilder.append("SELECT COUNT( DISTINCT  ");
            for (String field : pagableQueryInfo.getSelectFields()) {
                sqlBuilder.append(field + ",");
            }
            sqlBuilder.append(") ").deleteCharAt(sqlBuilder.lastIndexOf(",")).append(subSql);
        } else {
            sqlBuilder.append("SELECT COUNT(1) ").append(subSql);
        }
        pagableQueryInfo.getCondition().setTableName(pagableQueryInfo.getTableName());
        DWSqlInfo sqlInfo = this.parse(pagableQueryInfo.getCondition(), pagableQueryInfo.getFixedCondition());
        if (sqlInfo != null) {
            sqlBuilder.append(" WHERE ").append(sqlInfo.getSql());
            parameters = sqlInfo.getParametersAsList();
        }
        DWSqlInfo resultInfo = new DWSqlInfo(sqlBuilder.toString(), parameters);
        return resultInfo;
    }

    public String generateSelectSql(DWQueryInfo queryInfo) {
        StringBuilder sb = new StringBuilder();
        if (null == queryInfo) {
            throw new DWDataException("queryInfo cannot be null");
        }
        sb.append("SELECT ");
        if (queryInfo.isDistinct()) {
            sb.append(" DISTINCT ");
        }
        if (null != queryInfo.getSelectFields() && queryInfo.getSelectFields().size() > 0) {
            if (queryInfo.isSelectAll()) {
                HashMap<String, String> queryFieldsMap = new HashMap<String, String>();
                DWMetadata metadata = DWMetadataContainer.get((String)queryInfo.getTableName(), DWRdbmsMetadata.class);
                for (DWRdbmsField metadataField : metadata.getFields()) {
                    queryFieldsMap.put(metadataField.getName(), metadataField.getName());
                }
                String[] aliasArr = new String[2];
                for (String queryField : queryInfo.getSelectFields()) {
                    aliasArr = queryField.split(" ");
                    queryFieldsMap.put(aliasArr[0], aliasArr[0] + " AS " + aliasArr[1]);
                }
                for (String key : queryFieldsMap.keySet()) {
                    sb.append(queryFieldsMap.get(key) + ", ");
                }
            } else {
                for (String field : queryInfo.getSelectFields()) {
                    sb.append(field + ", ");
                }
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
        } else {
            sb.append(" * ");
        }
        sb.append(" FROM ").append(queryInfo.getTableName()).append(" ");
        return sb.toString();
    }

    @Override
    public DWSqlInfo parse(DWQueryInfo queryInfo) {
        return this.parse(queryInfo, null);
    }

    @Override
    public DWSqlInfo parse(DWQueryInfo queryInfo, String sql) {
        return this.parse(queryInfo, sql, null);
    }

    @Override
    public DWSqlInfo parse(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        if (option == null) {
            option = this.createDefaultOption();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        List<Object> parameters = new ArrayList<Object>();
        if (sql == null) {
            sql = this.generateSelectSql(queryInfo);
        }
        sqlBuilder.append(sql);
        DWQueryCondition additionalCondition = this.addSystemCondition(queryInfo, option);
        queryInfo.setCondition(additionalCondition);
        queryInfo.getCondition().setTableName(queryInfo.getTableName());
        DWSqlInfo sqlInfo = this.parse(queryInfo.getCondition(), queryInfo.getFixedCondition());
        if (sqlInfo != null) {
            boolean hasWhere;
            boolean bl = hasWhere = sql == null ? false : sql.toUpperCase().contains(" WHERE ");
            if (hasWhere) {
                sqlBuilder.append(" ").append(queryInfo.getCondition().getJoinOperator()).append(" ");
            } else {
                sqlBuilder.append(" WHERE ");
            }
            sqlBuilder.append(sqlInfo.getSql());
            parameters = sqlInfo.getParametersAsList();
        }
        if (null != queryInfo.getOrderfields() && !queryInfo.getOrderfields().isEmpty()) {
            sqlBuilder.append(" ORDER BY ");
            for (DWQueryOrderby queryOrderbyMap : queryInfo.getOrderfields()) {
                sqlBuilder.append(queryOrderbyMap.getName()).append(" ").append(queryOrderbyMap.getOrderby()).append(",");
            }
            sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        }
        if (queryInfo instanceof DWPagableQueryInfo) {
            DWPagableQueryInfo pagableQueryInfo = (DWPagableQueryInfo)queryInfo;
            int pageSize = pagableQueryInfo.getPageSize();
            int pageNumber = pagableQueryInfo.getPageNumber();
            this.attachPageSQLInfo(sqlBuilder, parameters, pageSize, pageNumber);
        }
        DWSqlInfo resultInfo = new DWSqlInfo(sqlBuilder.toString(), parameters);
        return resultInfo;
    }

    private DWSqlInfo parse(DWQueryCondition generalCondition, DWQueryCondition fixedCondition) {
        DWSqlInfo generalSqlInfo = this.parse(generalCondition);
        DWSqlInfo fixedSqlInfo = this.parse(fixedCondition);
        if (fixedSqlInfo == null && generalSqlInfo == null) {
            return null;
        }
        if (fixedSqlInfo == null) {
            return generalSqlInfo;
        }
        if (generalSqlInfo == null) {
            return fixedSqlInfo;
        }
        String mergedSql = String.format("(%s AND %s)", generalSqlInfo.getSql(), fixedSqlInfo.getSql());
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.addAll(generalSqlInfo.getParametersAsList());
        parameters.addAll(fixedSqlInfo.getParametersAsList());
        DWSqlInfo mergedSqlInfo = new DWSqlInfo(mergedSql, parameters);
        return mergedSqlInfo;
    }

    @Override
    public DWSqlInfo parse(DWQueryCondition condition) {
        if (condition == null || condition.size() == 0) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean hasOtherElementSQL = false;
        sqlBuilder.append("(");
        for (DWQueryElement element : condition.getItems()) {
            DWSqlInfo innerSqlInfo;
            if (element == null) continue;
            if (element instanceof DWQueryCondition) {
                innerSqlInfo = this.parse((DWQueryCondition)element);
            } else if (element instanceof DWQueryField) {
                ((DWQueryField)element).setTableName(condition.getTableName());
                innerSqlInfo = this.parse((DWQueryField)element);
            } else {
                throw new NotImplementedException("DWQueryConditionElement->" + element.getClass().getSimpleName() + " not support yet!");
            }
            if (innerSqlInfo == null) continue;
            if (hasOtherElementSQL) {
                sqlBuilder.append(" ").append(condition.getJoinOperator()).append(" ");
            }
            sqlBuilder.append(innerSqlInfo.getSql());
            parameters.addAll(innerSqlInfo.getParametersAsList());
            hasOtherElementSQL = true;
        }
        sqlBuilder.append(")");
        DWSqlInfo sqlInfo = new DWSqlInfo(sqlBuilder.toString(), parameters);
        return sqlInfo;
    }

    @Override
    public DWSqlInfo parse(DWQueryField fieldInfo) {
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        switch (fieldInfo.getOperator()) {
            case BETWEEN: 
            case Between: {
                sqlBuilder.append(fieldInfo.getName());
                sqlBuilder.append(" BETWEEN ? AND ?");
                parameters.addAll(Arrays.asList(fieldInfo.getValues()));
                break;
            }
            case EQUAL: 
            case Equals: {
                sqlBuilder.append(fieldInfo.getName());
                Object value = fieldInfo.getFirstValue();
                if (value == null) {
                    sqlBuilder.append(" is null");
                    break;
                }
                sqlBuilder.append(" = ?");
                parameters.add(fieldInfo.getFirstValue());
                break;
            }
            case NotEquals: {
                sqlBuilder.append(fieldInfo.getName());
                Object value2 = fieldInfo.getFirstValue();
                if (value2 == null) {
                    sqlBuilder.append(" is not null");
                    break;
                }
                sqlBuilder.append(" <> ?");
                parameters.add(fieldInfo.getFirstValue());
                break;
            }
            case LIKE: 
            case Like: 
            case GreaterThan: 
            case GreaterThanOrEqualTo: 
            case LessThan: 
            case LessThanOrEqualTo: {
                sqlBuilder.append(fieldInfo.getName());
                String sqlOperator = fieldInfo.getOperator().getValue().toUpperCase();
                sqlBuilder.append(" ").append(sqlOperator).append(" ?");
                parameters.add(fieldInfo.getFirstValue());
                break;
            }
            case IN: 
            case In: {
                sqlBuilder.append(fieldInfo.getName());
                sqlBuilder.append(" IN (");
                sqlBuilder.append(String.join((CharSequence)", ", Collections.nCopies(fieldInfo.getValues().length, "?")));
                sqlBuilder.append(")");
                parameters.addAll(Arrays.asList(fieldInfo.getValues()));
                break;
            }
            case NOTIN: 
            case NotIn: {
                DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)fieldInfo.getTableName(), DWRdbmsMetadata.class);
                Collection pkList = metadata.getPrimaryKeys();
                sqlBuilder.append(" NOT EXISTS ( ");
                sqlBuilder.append(" SELECT ");
                sqlBuilder.append(fieldInfo.getName());
                sqlBuilder.append(" FROM ");
                sqlBuilder.append(fieldInfo.getTableName());
                sqlBuilder.append(" AS tb2 WHERE ");
                for (String pk : pkList) {
                    sqlBuilder.append(fieldInfo.getTableName());
                    sqlBuilder.append(".");
                    sqlBuilder.append(pk);
                    sqlBuilder.append(" = tb2.");
                    sqlBuilder.append(pk);
                    sqlBuilder.append(" AND ");
                }
                sqlBuilder.append(" ( ");
                for (Object val : fieldInfo.getValues()) {
                    sqlBuilder.append(" tb2.");
                    sqlBuilder.append(fieldInfo.getName());
                    sqlBuilder.append(" = ? ");
                    parameters.add(val);
                    sqlBuilder.append(" OR");
                }
                sqlBuilder.delete(sqlBuilder.length() - 3, sqlBuilder.length());
                sqlBuilder.append(" )) ");
                break;
            }
            default: {
                throw new NotImplementedException(String.format("%s operator not support yet!", new Object[0]), fieldInfo.getOperator().toString());
            }
        }
        return new DWSqlInfo(sqlBuilder.toString(), parameters);
    }

    @Override
    public DWDataSetSqlInfo parse(DWDataSet dataset, DWDataSetOperationOption option) {
        DWDataSetSqlInfo datasetSqlInfo = new DWDataSetSqlInfo(dataset, option);
        for (DWDataTable dataTable : dataset.getTables()) {
            DWDataRowSqlInfo rowSqlInfo;
            DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)dataTable.getName(), DWRdbmsMetadata.class);
            for (DWDataRow row : dataTable.getRows()) {
                rowSqlInfo = this.parse(row, metadata, option);
                if (rowSqlInfo == null) continue;
                datasetSqlInfo.add(rowSqlInfo);
            }
            Iterator<DWDataRow> removedRows = dataTable.getRows().getIteratorOfRemovedRows();
            while (removedRows.hasNext()) {
                rowSqlInfo = this.parse(removedRows.next(), option);
                if (rowSqlInfo == null) continue;
                datasetSqlInfo.add(rowSqlInfo);
            }
        }
        datasetSqlInfo.sort(new DWDataRowSqlInfoComparator(datasetSqlInfo));
        return datasetSqlInfo;
    }

    @Override
    public DWDataRowSqlInfo parse(DWDataRow row, DWDataSetOperationOption option) {
        String tableName = row.getDataTable().getName();
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
        return this.parse(row, metadata, option);
    }

    private DWDataRowSqlInfo parse(DWDataRow row, DWRdbmsMetadata metadata, DWDataSetOperationOption option) {
        if (tenantEnabled && option != null && option.isTenantEnabled() && !row.getData().containsKey(tenantColumnName)) {
            Map profile = DWServiceContext.getContext().getProfile();
            if (profile.containsKey(IAM_TENANTSID)) {
                Long tenantSid = (Long)profile.get(IAM_TENANTSID);
                row.set(tenantColumnName, (Object)tenantSid);
            } else {
                throw new DWDataException("13012", String.format("[DWDAO]DWCommandSQL.parse: %s is missing in profile", IAM_TENANTSID));
            }
        }
        DWDataRowSqlInfo sqlInfo = null;
        switch (row.getState()) {
            case "C": {
                sqlInfo = this.parseInsertSql(row, metadata, option);
                break;
            }
            case "U": {
                sqlInfo = this.parseUpdateSql(row, metadata, option);
                break;
            }
            case "D": {
                sqlInfo = this.parseDeleteSql(row, metadata, option);
                break;
            }
            default: {
                if (row.getState() == "") break;
                throw new DWDataException("13008", String.format("This Operation[%s] is unknown!", row.getState()));
            }
        }
        return sqlInfo;
    }

    private Object processCellValue(Object cellValue, DWRdbmsField fieldInfo) {
        Object processValue = cellValue;
        if (fieldInfo.isNumericType() && !fieldInfo.isNullable() && (processValue == null || processValue.toString().length() == 0)) {
            processValue = 0;
        }
        return processValue;
    }

    private DWDataRowSqlInfo parseInsertSql(DWDataRow row, DWRdbmsMetadata metadata, DWDataSetOperationOption option) {
        String tableName = row.getDataTable().getName();
        Map<String, Object> dataMap = row.getData();
        Object cellValue = null;
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> insertColumnList = new ArrayList<String>();
        DWAutoIncrementOption.DWAutoIncrementSource valueSource = option.getInsertOption().getAutoIncrementOption().getSource(tableName);
        boolean hasAutoIncrementSource = valueSource != null;
        DWAutoIncrementOption.DWAutoIncrementValueProxy[] valueProxys = null;
        List<String> autoIncrementRefColumns = null;
        if (hasAutoIncrementSource) {
            valueProxys = valueSource.getValues();
            autoIncrementRefColumns = Arrays.stream(valueProxys).map(i -> i.getTargetColumn()).collect(Collectors.toList());
            for (String targetColumn : autoIncrementRefColumns) {
                if (dataMap.containsKey(targetColumn)) continue;
                row.set(targetColumn, null);
            }
        } else {
            autoIncrementRefColumns = Collections.emptyList();
        }
        sqlBuilder.append("INSERT INTO ").append(tableName).append("(");
        for (Map.Entry<String, Object> cell : dataMap.entrySet()) {
            DWRdbmsField rdbmsField;
            String columnName = cell.getKey();
            if (DWDataRowState.isRowStateColumn(columnName) || (cellValue = cell.getValue()) instanceof DWDataRowCollection || (rdbmsField = (DWRdbmsField)metadata.tryGetField(columnName)) == null) continue;
            cellValue = this.processCellValue(cellValue, rdbmsField);
            insertColumnList.add(columnName);
            if (autoIncrementRefColumns.contains(columnName) && cellValue == null) {
                DWAutoIncrementOption.DWAutoIncrementValueProxy valueProxy = Arrays.stream(valueProxys).filter(s -> s.getTargetColumn().equals(cell.getKey())).findFirst().get();
                params.add(valueProxy);
                continue;
            }
            params.add(cellValue);
        }
        sqlBuilder.append(String.join((CharSequence)", ", insertColumnList)).append(") VALUES (").append(String.join((CharSequence)", ", Collections.nCopies(insertColumnList.size(), "?"))).append(")");
        DWDataRowSqlInfo sqlInfo = new DWDataRowSqlInfo(metadata, row, sqlBuilder.toString(), params);
        return sqlInfo;
    }

    public boolean containsIgnoreCase(String str, Collection<String> list) {
        for (String i : list) {
            if (!i.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private DWDataRowSqlInfo parseUpdateSql(DWDataRow row, DWRdbmsMetadata metadata, DWDataSetOperationOption option) {
        Object cellValue;
        String tableName = row.getDataTable().getName();
        Map<String, Object> dataMap = row.getData();
        Collection pkList = metadata.getPrimaryKeys();
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        String versionControlFieldName = metadata.getVersionControl();
        Object currentVersion = null;
        HashMap<String, Object> pkInfo = new HashMap<String, Object>();
        DWDataOptimisticLockingInfo lockingInfo = null;
        sqlBuilder.append("UPDATE ").append(tableName).append(" SET ");
        for (Map.Entry<String, Object> cell : dataMap.entrySet()) {
            DWRdbmsField rdbmsField;
            String columnName = cell.getKey();
            if (DWDataRowState.isRowStateColumn(columnName) || (cellValue = cell.getValue()) instanceof DWDataRowCollection || (rdbmsField = (DWRdbmsField)metadata.tryGetField(columnName)) == null) continue;
            columnName = rdbmsField.getName();
            cellValue = this.processCellValue(cellValue, rdbmsField);
            if (versionControlFieldName != null && versionControlFieldName.equalsIgnoreCase(columnName.toLowerCase())) {
                sqlBuilder.append(columnName).append(" = ").append(columnName).append(" + 1,");
                currentVersion = cellValue;
                lockingInfo = new DWDataOptimisticLockingInfo(tableName);
                lockingInfo.setLockingVersion(currentVersion);
                continue;
            }
            if (pkList.contains(cell.getKey())) {
                pkInfo.put(columnName, cellValue);
                continue;
            }
            sqlBuilder.append(cell.getKey() + " = ? ,");
            params.add(cellValue);
        }
        if (params.size() == 0) {
            log.debug((Object)("this row [" + row + "] has no any update field info!"));
            return null;
        }
        if (pkList.isEmpty()) {
            DWCommonSQLDialect.throwNoPKInMetadataException(tableName);
        }
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(",")).append(" WHERE 1=1 ");
        for (String pk : pkList) {
            sqlBuilder.append(" AND " + pk + " = ?");
            cellValue = pkInfo.get(pk);
            if (cellValue == null) {
                DWCommonSQLDialect.throwPKFieldIsNullException(row, pk);
            }
            params.add(cellValue);
        }
        if (lockingInfo != null) {
            lockingInfo.setPrimaryKeyInfo(pkInfo);
            sqlBuilder.append(" AND ").append(versionControlFieldName).append(" = ").append("?");
            params.add(currentVersion);
        }
        DWDataRowSqlInfo sqlInfo = new DWDataRowSqlInfo(metadata, row, sqlBuilder.toString(), params);
        if (lockingInfo != null) {
            sqlInfo.setLockingInfo(lockingInfo);
        }
        return sqlInfo;
    }

    private static void throwNoPKInMetadataException(String tableName) {
        throw new DWDataException("13009", String.format("Table(%s) has no any Primary Key definition!", tableName));
    }

    private static void throwPKFieldIsNullException(DWDataRow row, String pk) {
        throw new DWDataException("13010", String.format("This row(%s) pk field(%s) value is null!", row, pk));
    }

    private DWDataRowSqlInfo parseDeleteSql(DWDataRow row, DWRdbmsMetadata metadata, DWDataSetOperationOption option) {
        String tableName = row.getDataTable().getName();
        Map<String, Object> dataMap = row.getData();
        Collection pkList = metadata.getPrimaryKeys();
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        String versionControlFieldName = metadata.getVersionControl();
        sqlBuilder.append("DELETE FROM ").append(tableName).append(" WHERE ");
        if (pkList.isEmpty()) {
            DWCommonSQLDialect.throwNoPKInMetadataException(tableName);
        }
        int i = 0;
        HashMap<String, Object> pkInfo = new HashMap<String, Object>();
        for (String pk : pkList) {
            if (++i != 1) {
                sqlBuilder.append(" AND ");
            }
            sqlBuilder.append(pk).append(" = ?");
            Optional<String> result = dataMap.keySet().stream().filter(key -> key.equalsIgnoreCase(pk)).findFirst();
            if (result.isPresent()) {
                Object pkValue = dataMap.get(result.get());
                params.add(pkValue);
                pkInfo.put(pk, pkValue);
                continue;
            }
            DWCommonSQLDialect.throwPKFieldIsNullException(row, pk);
        }
        DWDataOptimisticLockingInfo lockingInfo = null;
        if (versionControlFieldName != null && dataMap.containsKey(versionControlFieldName)) {
            Object currentVersion = dataMap.get(versionControlFieldName);
            sqlBuilder.append(" AND ");
            sqlBuilder.append(versionControlFieldName).append(" = ?");
            params.add(currentVersion);
            lockingInfo = new DWDataOptimisticLockingInfo(tableName);
            lockingInfo.setLockingVersion(currentVersion);
            lockingInfo.setPrimaryKeyInfo(pkInfo);
        }
        DWDataRowSqlInfo sqlInfo = new DWDataRowSqlInfo(metadata, row, sqlBuilder.toString(), params);
        if (lockingInfo != null) {
            sqlInfo.setLockingInfo(lockingInfo);
        }
        return sqlInfo;
    }

    @Override
    public DWSqlInfo parseDeleteSql(String tableName, DWQueryCondition condition) {
        DWSqlInfo conditionSqlInfo = this.parse(condition);
        StringBuilder delSql = new StringBuilder();
        delSql.append("DELETE FROM ").append(tableName).append(" WHERE ").append(conditionSqlInfo.getSql());
        DWSqlInfo sqlInfo = new DWSqlInfo(delSql.toString(), conditionSqlInfo.getParametersAsList());
        return sqlInfo;
    }

    private DWQueryCondition addSystemCondition(DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        DWQueryCondition originalCondition = queryInfo.getCondition();
        boolean isExistTenantCondition = false;
        if (tenantEnabled && option.isTenantEnabled()) {
            Map profile = DWServiceContext.getContext().getProfile();
            if (profile.containsKey(IAM_TENANTSID)) {
                String tableName = queryInfo.getTableName();
                String tenantFullColunmName = tenantColumnName;
                if (StringUtils.isNotBlank((CharSequence)tableName)) {
                    tenantFullColunmName = tableName + "." + tenantColumnName;
                }
                if (originalCondition != null && originalCondition.size() > 0) {
                    for (DWQueryElement element : originalCondition.getItems()) {
                        DWQueryField field;
                        if (!(element instanceof DWQueryField) || !(field = (DWQueryField)element).getName().equals(tenantFullColunmName)) continue;
                        isExistTenantCondition = true;
                    }
                }
                DWQueryCondition systemCondition = new DWQueryCondition();
                if (isExistTenantCondition) {
                    systemCondition = originalCondition;
                } else {
                    systemCondition.addCondition(originalCondition);
                    systemCondition.addEqualInfo(tenantFullColunmName, profile.get(IAM_TENANTSID));
                }
                return systemCondition;
            }
            throw new DWDataException("13013", String.format("[DWDAO]DWCommonSQLDialect.addSystemCondition: %s is missing in profile", IAM_TENANTSID));
        }
        return originalCondition;
    }

    public class CustomStringList
    extends ArrayList<String> {
        @Override
        public boolean contains(Object o) {
            String paramStr = (String)o;
            for (String s : this) {
                if (!paramStr.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }
    }

    private class DWDataRowSqlInfoComparator
    implements Comparator<DWDataRowSqlInfo> {
        private Map<String, Integer> weightInfo = new HashMap<String, Integer>();

        private DWDataRowSqlInfoComparator(DWDataSetSqlInfo datasetSqlInfo) {
            this.analyze(datasetSqlInfo);
        }

        private boolean allMatched(Collection<String> targetJoinKeys, Collection<String> targetPrimaryKeys) {
            return targetPrimaryKeys.stream().allMatch(pk -> targetJoinKeys.contains(pk));
        }

        private int getAvailableWeight(int baseWeight, boolean higher) {
            ArrayList<Integer> sortedWeightInfo = new ArrayList<Integer>(this.weightInfo.values());
            Collections.sort(sortedWeightInfo);
            Integer maxWeight = null;
            Integer previousWeight = null;
            Iterator iterator = sortedWeightInfo.iterator();
            while (iterator.hasNext()) {
                Integer weight;
                previousWeight = weight = (Integer)iterator.next();
                if (baseWeight >= weight) continue;
                maxWeight = weight;
                break;
            }
            if (maxWeight == null) {
                maxWeight = (Integer)sortedWeightInfo.get(sortedWeightInfo.size() - 1);
                return maxWeight * 2;
            }
            return previousWeight + (maxWeight - previousWeight) / 2;
        }

        private void updateWeightInfo(DWRdbmsMetadata primaryMetadata, DWRdbmsRelationshipAttribute ra) {
            String primaryTableName = primaryMetadata.getName();
            String targetTableName = ra.getDetailTableName();
            DWRdbmsMetadata targetMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)targetTableName, DWRdbmsMetadata.class);
            int baseWeight = 1000;
            boolean isOneToMany = ra.isOneToMany();
            boolean isOneToOne = ra.isOneToOne();
            Integer primaryWeight = null;
            Integer targetWeight = null;
            primaryWeight = this.weightInfo.get(primaryTableName);
            targetWeight = this.weightInfo.get(targetTableName);
            if (isOneToMany) {
                if (primaryWeight == null) {
                    primaryWeight = baseWeight;
                }
                if (targetWeight == null) {
                    targetWeight = primaryWeight / 2;
                } else if (targetWeight >= primaryWeight) {
                    primaryWeight = this.getAvailableWeight(targetWeight, true);
                }
                this.weightInfo.put(primaryTableName, primaryWeight);
                this.weightInfo.put(targetTableName, targetWeight);
            } else if (isOneToOne) {
                isOneToOne = true;
                if (targetWeight == null) {
                    targetWeight = baseWeight;
                }
                if (primaryWeight == null) {
                    primaryWeight = targetWeight / 2;
                } else if (primaryWeight >= targetWeight) {
                    targetWeight = this.getAvailableWeight(primaryWeight, true);
                }
                this.weightInfo.put(primaryTableName, primaryWeight);
                this.weightInfo.put(targetTableName, targetWeight);
            }
        }

        private void analyze(DWDataSetSqlInfo datasetSqlInfo) {
            ArrayList<DWRdbmsMetadata> metadatas = new ArrayList<DWRdbmsMetadata>();
            for (DWDataRowSqlInfo sqlInfo : datasetSqlInfo) {
                DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)sqlInfo.getRow().getDataTable().getName(), DWRdbmsMetadata.class);
                if (metadatas.contains(metadata)) continue;
                metadatas.add(metadata);
            }
            metadatas.stream().forEach(m -> {
                Collection relations = m.getAttributes(DWRdbmsRelationshipAttribute.class);
                for (DWRdbmsRelationshipAttribute ra : relations) {
                    this.updateWeightInfo((DWRdbmsMetadata)m, ra);
                }
            });
        }

        @Override
        public int compare(DWDataRowSqlInfo sqlInfo1, DWDataRowSqlInfo sqlInfo2) {
            DWDataRow row1 = sqlInfo1.getRow();
            DWDataRow row2 = sqlInfo2.getRow();
            if (row1.isNew()) {
                if (!row2.isNew()) {
                    return -1;
                }
            } else if (row2.isNew()) {
                return 1;
            }
            if (row1.isNew() && row2.isNew() && !row1.getDataTable().getName().equals(row2.getDataTable().getName())) {
                Integer row1Weight = this.weightInfo.get(row1.getDataTable().getName());
                Integer row2Weight = this.weightInfo.get(row2.getDataTable().getName());
                if (row1Weight == null) {
                    row1Weight = 0;
                }
                if (row2Weight == null) {
                    row2Weight = 0;
                }
                return row1Weight > row2Weight ? -1 : (row1Weight < row2Weight ? 1 : 0);
            }
            if (row1.isDeleted() && row2.isDeleted() && !row1.getDataTable().getName().equals(row2.getDataTable().getName())) {
                Integer row1Weight = this.weightInfo.get(row1.getDataTable().getName());
                Integer row2Weight = this.weightInfo.get(row2.getDataTable().getName());
                if (row1Weight == null) {
                    row1Weight = 0;
                }
                if (row2Weight == null) {
                    row2Weight = 0;
                }
                return row1Weight > row2Weight ? 1 : (row1Weight < row2Weight ? -1 : 0);
            }
            return 0;
        }
    }
}

