/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.dao.DWDataSetSqlInfo;
import com.digiwin.app.dao.DWDataTableHandler;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.dialect.DWMySQLDialect;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.data.DWAutoIncrementOption;
import com.digiwin.app.data.DWCascadeDeletingInfo;
import com.digiwin.app.data.DWCascadeQueryInfo;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowInfoUtils;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.data.exceptions.DWDataOptimisticLockingException;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDaoImpl
implements DWDao {
    private DWSQLDialect dialect;
    QueryRunner queryRunner;
    private static Log log = LogFactory.getLog(DWDaoImpl.class);

    public DWDaoImpl(QueryRunner queryRunner) {
        this.queryRunner = queryRunner;
    }

    @Override
    public List<Map<String, Object>> select(String statement, Object ... params) throws Exception {
        this.logSqlExecutingInfo(statement, params);
        List result = (List)this.queryRunner.query(statement, (ResultSetHandler)new MapListHandler(), params);
        return result;
    }

    public void setDialectClassName(String dialectClass) throws Exception {
        Class<?> dialectClazz = this.getClass().getClassLoader().loadClass(dialectClass);
        this.dialect = (DWSQLDialect)dialectClazz.newInstance();
    }

    public void setDialect(DWSQLDialect dialect) throws Exception {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect is null!");
        }
        this.dialect = dialect;
    }

    public DWSQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = new DWMySQLDialect();
        }
        return this.dialect;
    }

    @Override
    public int update(String statement, Object ... params) throws Exception {
        this.logSqlExecutingInfo(statement, params);
        int result = this.queryRunner.update(statement, params);
        return result;
    }

    @Override
    @Deprecated
    public DWDataSet select(DWQueryInfo queryInfo, String sql) throws Exception {
        return this.select(queryInfo, sql, new DWDataSetOperationOption());
    }

    @Override
    @Deprecated
    public DWDataSet select(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) throws Exception {
        DWSqlInfo sqlInfo = this.getDialect().parse(queryInfo, sql, option);
        this.logSqlExecutingInfo(sqlInfo);
        DWDataTable dataTable = (DWDataTable)this.queryRunner.query(sqlInfo.getSql(), (ResultSetHandler)new DWDataTableHandler(queryInfo), sqlInfo.getParameters());
        this.cascadeSelect(dataTable, option);
        return dataTable.getDataSet();
    }

    private void cascadeSelect(DWDataTable dataTable, DWDataSetOperationOption option) throws Exception {
        if (option == null) {
            return;
        }
        String primaryTableName = dataTable.getName();
        List<DWCascadeQueryInfo> queryList = option.getCascadingQueryList();
        if (queryList.size() == 0) {
            return;
        }
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)primaryTableName, DWRdbmsMetadata.class);
        Collection relations = metadata.getAttributes(DWRdbmsRelationshipAttribute.class);
        List cascadeList = queryList.stream().filter(item -> primaryTableName.equals(item.getPrimary())).collect(Collectors.toList());
        for (DWCascadeQueryInfo cascadTarget : cascadeList) {
            String referenceName = cascadTarget.getReference();
            DWRdbmsRelationshipAttribute targetAttribute = relations.stream().filter(attr -> attr.getDetailTableName().equals(referenceName)).findFirst().get();
            if (targetAttribute == null) {
                throw new DWDataException(String.format("cascade Query reference(%s) is not found in metadata", referenceName));
            }
            this.cascadeSelect(dataTable, cascadTarget, targetAttribute, option);
        }
    }

    private void cascadeSelect(DWDataTable dataTable, DWCascadeQueryInfo cascadeQueryInfo, DWRdbmsRelationshipAttribute relation, DWDataSetOperationOption option) throws Exception {
        DWQueryInfo userdefinedQueryInfo = cascadeQueryInfo.getQueryInfo();
        dataTable.getRows().stream().forEach(row -> {
            DWRdbmsMetadata relationTableMetadata;
            boolean autoCaculateMaxSeq;
            DWQueryInfo rowQueryInfo;
            boolean isPagableQueryInfo = userdefinedQueryInfo instanceof DWPagableQueryInfo;
            DWQueryInfo dWQueryInfo = rowQueryInfo = isPagableQueryInfo ? new DWPagableQueryInfo() : new DWQueryInfo();
            if (isPagableQueryInfo) {
                DWPagableQueryInfo userdefinedPagableQueryInfo = (DWPagableQueryInfo)userdefinedQueryInfo;
                DWQueryInfo rowPagableQueryInfo = rowQueryInfo;
                ((DWPagableQueryInfo)rowPagableQueryInfo).setPageSize(userdefinedPagableQueryInfo.getPageSize());
                ((DWPagableQueryInfo)rowPagableQueryInfo).setPageNumber(userdefinedPagableQueryInfo.getPageNumber());
            }
            this.addRelationConditions((DWDataRow)row, relation, rowQueryInfo);
            rowQueryInfo.getOrderfields().addAll(userdefinedQueryInfo.getOrderfields());
            rowQueryInfo.setSelectFields(userdefinedQueryInfo.getSelectFields());
            if (userdefinedQueryInfo.getCondition() != null) {
                DWQueryCondition userDefinedCondition = userdefinedQueryInfo.getCondition().clone();
                rowQueryInfo.getCondition().addCondition(userDefinedCondition);
            }
            String relationTableName = relation.getDetailTableName();
            boolean bl = autoCaculateMaxSeq = option.isCalculateMaxSeqEnabled() && option.getCalculateMaxSeqFieldName() != null && !option.getCalculateMaxSeqFieldName().isEmpty();
            if (autoCaculateMaxSeq && !(relationTableMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)relationTableName, DWRdbmsMetadata.class)).hasField(option.getCalculateMaxSeqFieldName())) {
                autoCaculateMaxSeq = false;
            }
            try {
                rowQueryInfo.setTableName(relation.getDetailTableName());
                DWDataSet referenceDataset = null;
                if (isPagableQueryInfo) {
                    DWPaginationQueryResult paginationResult = this.selectWithPage((DWPagableQueryInfo)rowQueryInfo, option);
                    referenceDataset = paginationResult.getDataSet();
                    DWDataRowInfoUtils.setChildPageInfo(row, relation.getDetailTableName(), paginationResult);
                    if (autoCaculateMaxSeq) {
                        DWQueryInfo queryMaxSqlInfo = new DWQueryInfo();
                        queryMaxSqlInfo.setTableName(relation.getDetailTableName());
                        queryMaxSqlInfo.setSelectFields("max(" + option.getCalculateMaxSeqFieldName() + ") as maxSeq");
                        this.addRelationConditions((DWDataRow)row, relation, queryMaxSqlInfo);
                        DWDataRow maxRow = this.selectOne(queryMaxSqlInfo, option);
                        Object maxSeqSourceValue = maxRow.get("maxSeq");
                        long maxSeq = maxSeqSourceValue == null ? 0L : Long.parseLong(maxSeqSourceValue.toString());
                        DWDataRowInfoUtils.setChildSeqInfo(row, relation.getDetailTableName(), option.getCalculateMaxSeqFieldName(), maxSeq);
                    }
                } else {
                    referenceDataset = this.select(rowQueryInfo, null, option);
                    if (autoCaculateMaxSeq) {
                        long maxSeq = this.getMaxSeqInTable(referenceDataset.getTable(relationTableName), option.getCalculateMaxSeqFieldName());
                        DWDataRowInfoUtils.setChildSeqInfo(row, relationTableName, option.getCalculateMaxSeqFieldName(), maxSeq);
                    }
                }
                row.set(relation.getDetailTableName(), (Object)referenceDataset);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private long getMaxSeqInTable(DWDataTable table, String seqFieldName) {
        long maxSeq = 0L;
        long seqLongValue = 0L;
        for (DWDataRow row : table.getRows()) {
            Object seqValue = row.get(seqFieldName);
            if (seqValue == null || maxSeq >= (seqLongValue = Long.parseLong(seqValue.toString()))) continue;
            maxSeq = seqLongValue;
        }
        return maxSeq;
    }

    private void addRelationConditions(DWDataRow primaryRow, DWRdbmsRelationshipAttribute relationAttribute, DWQueryInfo referenceQueryInfo) {
        Map joinColumns = relationAttribute.getJoinColumns();
        for (Map.Entry item : joinColumns.entrySet()) {
            String primaryField = (String)item.getKey();
            String referenceField = (String)item.getValue();
            Object value = primaryRow.get(primaryField);
            referenceQueryInfo.addEqualInfo(referenceField, value);
        }
    }

    @Override
    @Deprecated
    public DWDataRow selectOne(DWQueryInfo queryInfo, String sql) throws Exception {
        return this.selectOne(queryInfo, sql, null);
    }

    @Override
    @Deprecated
    public DWDataRow selectOne(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) throws Exception {
        DWDataSet dataset = this.select(queryInfo, sql, option);
        DWDataTable primaryTable = dataset.getTables().getPrimaryTable();
        int size = primaryTable.getRows().size();
        if (size > 1) {
            throw new DWDataException("13015", "There are more than one row in dataset!");
        }
        if (size == 0) {
            return null;
        }
        return primaryTable.getRow(0);
    }

    @Override
    @Deprecated
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, String sql) throws Exception {
        return this.selectWithPage(pagableQueryInfo, sql, new DWDataSetOperationOption());
    }

    @Override
    @Deprecated
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, String sql, DWDataSetOperationOption option) throws Exception {
        DWSQLDialect dialect = this.getDialect();
        int totalCount = 0;
        DWSqlInfo sqlInfo = dialect.parse(pagableQueryInfo, sql, option);
        DWSqlInfo countSqlInfo = dialect.parseCount(pagableQueryInfo, sql, option);
        this.logSqlExecutingInfo(countSqlInfo);
        List countResult = (List)this.queryRunner.query(countSqlInfo.getSql(), (ResultSetHandler)new MapListHandler(), countSqlInfo.getParameters());
        this.logSqlExecutingInfo(sqlInfo);
        DWDataTable dataTable = (DWDataTable)this.queryRunner.query(sqlInfo.getSql(), (ResultSetHandler)new DWDataTableHandler(pagableQueryInfo), sqlInfo.getParameters());
        if (null != countResult && null != countResult.get(0)) {
            Map countRow = (Map)countResult.get(0);
            Map.Entry countCell = countRow.entrySet().iterator().next();
            totalCount = Integer.parseInt(countCell.getValue().toString());
        }
        this.cascadeSelect(dataTable, option);
        DWDataSet dataset = dataTable.getDataSet();
        DWPaginationQueryResult paginationQueryResult = new DWPaginationQueryResult(pagableQueryInfo.getPageSize(), totalCount);
        paginationQueryResult.setCurrentPage(pagableQueryInfo.getPageNumber(), dataset);
        return paginationQueryResult;
    }

    @Override
    public DWSQLExecutionResult execute(DWDataSet dataset) throws Exception {
        return this.execute(dataset, null);
    }

    private void logSqlExecutingInfo(String sql, Object ... params) throws Exception {
        log.info((Object)("[SQL.statement]" + sql));
        log.info((Object)("[SQL.params]" + (params == null ? "[]" : Arrays.asList(params))));
    }

    private void logSqlExecutingInfo(DWSqlInfo sqlInfo) throws Exception {
        log.info((Object)("[SQL.statement]" + sqlInfo.getSql()));
        StringBuilder parameterInfo = new StringBuilder();
        Object[] parameters = sqlInfo.getParameters();
        int seq = 0;
        int count = parameters.length;
        for (Object p : parameters) {
            parameterInfo.append(p);
            if (p == null) {
                parameterInfo.append("(Unknown)");
            } else {
                parameterInfo.append("(").append(p.getClass().getSimpleName()).append(")");
            }
            if (++seq == count) continue;
            parameterInfo.append(", ");
        }
        log.info((Object)("[SQL.params]" + parameterInfo.toString()));
    }

    private DWDataRow findImplicitParentRow(DWDataRowSqlInfo rowSqlInfo, DWDataSetOperationOption option, DWAutoIncrementOption.DWAutoIncrementSource valueSource) {
        String sourceTable = valueSource.getSourceTable();
        DWDataRow sourceRow = null;
        DWDataSet dataset = rowSqlInfo.getRow().getDWDataSet();
        DWDataTable table = dataset.getTable(sourceTable);
        if (table.getRows().size() == 1) {
            sourceRow = table.getRow(0);
        }
        return sourceRow;
    }

    private void assignAutoIncrementRefColumnValues(DWDataRowSqlInfo rowSqlInfo, DWDataSetOperationOption option) throws Exception {
        String tableName = rowSqlInfo.getTableName();
        DWAutoIncrementOption.DWAutoIncrementSource valueSource = option.getInsertOption().getAutoIncrementOption().getSource(tableName);
        if (valueSource != null) {
            DWDataRow targetRow = rowSqlInfo.getRow();
            DWDataRow sourceRow = targetRow.getParentRow();
            List<Object> parameters = rowSqlInfo.getParametersAsList();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!(parameters.get(i) instanceof DWAutoIncrementOption.DWAutoIncrementValueProxy)) continue;
                if (sourceRow == null) {
                    sourceRow = this.findImplicitParentRow(rowSqlInfo, option, valueSource);
                }
                if (sourceRow == null) {
                    parameters.set(i, null);
                    throw new DWDataException("13016", String.format("Row(%s) has no parent row or explicit parent more than one!", targetRow));
                }
                DWAutoIncrementOption.DWAutoIncrementValueProxy valueProxy = (DWAutoIncrementOption.DWAutoIncrementValueProxy)parameters.get(i);
                Object value = valueProxy.applyValue(sourceRow, targetRow);
                parameters.set(i, value);
            }
        }
    }

    @Override
    public DWSQLExecutionResult execute(DWDataSet dataset, DWDataSetOperationOption option) throws Exception {
        if (null == dataset) {
            throw new Exception("dataset cannot be null!!");
        }
        if (option == null) {
            option = new DWDataSetOperationOption();
        }
        DWDataSetSqlInfo datasqlInfo = this.getDialect().parse(dataset, option);
        DWSQLExecutionResult resultInfo = new DWSQLExecutionResult();
        for (DWDataRowSqlInfo rowSqlInfo : datasqlInfo) {
            this.logSqlExecutingInfo(rowSqlInfo);
            String operation = rowSqlInfo.getState();
            String tableName = rowSqlInfo.getTableName();
            switch (operation) {
                case "C": {
                    int count;
                    this.assignAutoIncrementRefColumnValues(rowSqlInfo, option);
                    if (rowSqlInfo.getMetadata().getAutoIncrement() != null) {
                        List<Object> generatedKeys = this.insertReturnGeneratedKeys(rowSqlInfo);
                        if (generatedKeys.size() == 1) {
                            rowSqlInfo.getRow().set(rowSqlInfo.getMetadata().getAutoIncrement(), generatedKeys.get(0));
                        } else if (generatedKeys.size() > 1) {
                            throw new DWDataException("13011", String.format("This row(%s) generate more than one keys!", rowSqlInfo.getRow()));
                        }
                        count = generatedKeys.size();
                        resultInfo.addGeneratedKeys(tableName, generatedKeys);
                    } else {
                        count = this.insert(rowSqlInfo);
                    }
                    resultInfo.addInsertCount(tableName, count);
                    break;
                }
                case "U": {
                    int count = this.update(rowSqlInfo);
                    resultInfo.addUpdateCount(tableName, count);
                    break;
                }
                case "D": {
                    this.cascadeDelete(rowSqlInfo, option, resultInfo);
                    int count = this.delete(rowSqlInfo);
                    resultInfo.addDeleteCount(tableName, count);
                    break;
                }
                default: {
                    throw new DWDataException("13008", String.format("This Operation[%s] is unknown!", operation));
                }
            }
            rowSqlInfo.persist();
        }
        return resultInfo;
    }

    public int insert(DWSqlInfo sqlInfo) throws Exception {
        int result = this.queryRunner.update(sqlInfo.getSql(), sqlInfo.getParameters());
        return result;
    }

    public List<Object> insertReturnGeneratedKeys(DWSqlInfo sqlInfo) throws Exception {
        List insertResult = (List)this.queryRunner.insert(sqlInfo.getSql(), (ResultSetHandler)new MapListHandler(), sqlInfo.getParameters());
        List<Object> generatedKeys = null;
        generatedKeys = insertResult == null ? Collections.emptyList() : insertResult.stream().map(i -> i.get("insert_id")).collect(Collectors.toList());
        return generatedKeys;
    }

    public int update(DWSqlInfo sqlInfo) throws Exception {
        int result = this.queryRunner.update(sqlInfo.getSql(), sqlInfo.getParameters());
        DWDataOptimisticLockingInfo lockingInfo = sqlInfo.getLockingInfo();
        if (lockingInfo != null && result != 1) {
            throw new DWDataOptimisticLockingException(lockingInfo);
        }
        return result;
    }

    private void cascadeDelete(DWDataRowSqlInfo sqlInfo, DWDataSetOperationOption option, DWSQLExecutionResult resultInfo) throws Exception {
        List<DWCascadeDeletingInfo> deleteList = option.getCascadingDeletingList();
        if (deleteList.size() == 0) {
            return;
        }
        DWDataRow dataRow = sqlInfo.getRow();
        DWDataTable dataTable = dataRow.getDataTable();
        String primaryTableName = dataTable.getName();
        CascadeDeletingInstruction instruction = new CascadeDeletingInstruction(primaryTableName, option, resultInfo);
        if (!instruction.hasReferenceCascadeSetting()) {
            return;
        }
        for (DWCascadeDeletingInfo cascadeTarget : instruction.getCascadeDeletingList()) {
            this.cascadeDelete(dataRow, cascadeTarget, instruction);
        }
    }

    private boolean cascadeDelete(DWDataRow sourceRow, DWCascadeDeletingInfo cascadeDeleteInfo, CascadeDeletingInstruction instruction) throws Exception {
        String primaryTableName = cascadeDeleteInfo.getReference();
        CascadeDeletingInstruction innerInstruction = new CascadeDeletingInstruction(primaryTableName, instruction.option, instruction.resultInfo);
        boolean hasReferenceCascadeSetting = innerInstruction.hasReferenceCascadeSetting();
        if (hasReferenceCascadeSetting) {
            HashMap<DWCascadeDeletingInfo, Boolean> cascadeDeleteReference = new HashMap<DWCascadeDeletingInfo, Boolean>();
            DWDataTable refDataTable = this.queryCascadeDeletingDataRows(sourceRow, cascadeDeleteInfo, instruction);
            for (DWDataRow dataRow : refDataTable.getRows()) {
                for (DWCascadeDeletingInfo cascadeTarget : innerInstruction.getCascadeDeletingList()) {
                    if (cascadeDeleteReference.containsKey(cascadeTarget) && !((Boolean)cascadeDeleteReference.get(cascadeTarget)).booleanValue()) continue;
                    cascadeDeleteReference.put(cascadeTarget, this.cascadeDelete(dataRow, cascadeTarget, innerInstruction));
                }
            }
            log.info((Object)String.format(">Cascade delete (%s)...source row (%s)", primaryTableName, sourceRow));
            int count = refDataTable.getRows().size();
            for (int i = count - 1; i >= 0; --i) {
                refDataTable.getRows().deleteAt(i);
            }
            DWSQLExecutionResult result = this.execute(refDataTable.getDataSet());
            if (result instanceof DWSQLExecutionResult) {
                DWSQLExecutionResult cascadeDeleteResult = result;
                int deleteCount = cascadeDeleteResult.getDeleteCount();
                innerInstruction.resultInfo.addDeleteCount(refDataTable.getName(), deleteCount);
            }
        } else {
            DWRdbmsRelationshipAttribute relation = instruction.getMappingAttribute(cascadeDeleteInfo);
            DWQueryCondition rowDeleteCondition = new DWQueryCondition();
            for (Map.Entry item : relation.getJoinColumns().entrySet()) {
                rowDeleteCondition.addEqualInfo((String)item.getValue(), sourceRow.get((String)item.getKey()));
            }
            DWQueryCondition userDefinedCondition = cascadeDeleteInfo.getCondition().clone();
            rowDeleteCondition.addCondition(userDefinedCondition);
            DWSqlInfo sqlInfo = this.getDialect().parseDeleteSql(primaryTableName, rowDeleteCondition);
            log.info((Object)String.format(">Cascade delete (%s)...source row (%s)", primaryTableName, sourceRow));
            this.logSqlExecutingInfo(sqlInfo);
            int delectCount = this.delete(sqlInfo);
            instruction.resultInfo.addDeleteCount(primaryTableName, delectCount);
        }
        return hasReferenceCascadeSetting;
    }

    private DWDataTable queryCascadeDeletingDataRows(DWDataRow sourceRow, DWCascadeDeletingInfo cascadeTarget, CascadeDeletingInstruction instruction) throws Exception {
        DWRdbmsRelationshipAttribute relation = instruction.getMappingAttribute(cascadeTarget);
        Map joinColumns = relation.getJoinColumns();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(relation.getDetailTableName());
        DWQueryInfo queryInfo = new DWQueryInfo();
        for (Map.Entry item : joinColumns.entrySet()) {
            Object value = sourceRow.get((String)item.getKey());
            queryInfo.addEqualInfo((String)item.getValue(), value);
        }
        queryInfo.getCondition().addCondition(cascadeTarget.getCondition().clone());
        DWDataSet dataset = this.select(queryInfo, sql.toString());
        DWDataTable dataTable = dataset.getTable(relation.getDetailTableName());
        return dataTable;
    }

    public int delete(DWSqlInfo sqlInfo) throws Exception {
        int result = this.queryRunner.update(sqlInfo.getSql(), sqlInfo.getParameters());
        DWDataOptimisticLockingInfo lockingInfo = sqlInfo.getLockingInfo();
        if (lockingInfo != null && result != 1) {
            throw new DWDataOptimisticLockingException(lockingInfo);
        }
        return result;
    }

    @Override
    public DWDataSet select(DWQueryInfo queryInfo) throws Exception {
        return this.select(queryInfo, null, new DWDataSetOperationOption());
    }

    @Override
    public DWDataSet select(DWQueryInfo queryInfo, DWDataSetOperationOption option) throws Exception {
        return this.select(queryInfo, null, option);
    }

    @Override
    public DWDataRow selectOne(DWQueryInfo queryInfo) throws Exception {
        DWDataSetOperationOption option = null;
        return this.selectOne(queryInfo, option);
    }

    @Override
    public DWDataRow selectOne(DWQueryInfo queryInfo, DWDataSetOperationOption option) throws Exception {
        String sql = null;
        return this.selectOne(queryInfo, sql, option);
    }

    @Override
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo) throws Exception {
        String sql = null;
        return this.selectWithPage(pagableQueryInfo, sql);
    }

    @Override
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, DWDataSetOperationOption option) throws Exception {
        return this.selectWithPage(pagableQueryInfo, null, option);
    }

    private class CascadeDeletingInstruction {
        private String primaryTableName;
        private DWSQLExecutionResult resultInfo;
        private DWDataSetOperationOption option;
        private List<DWCascadeDeletingInfo> deleteList;
        private Collection<DWRdbmsRelationshipAttribute> relations = null;

        private CascadeDeletingInstruction(String primaryTableName, DWDataSetOperationOption option, DWSQLExecutionResult resultInfo) {
            this.primaryTableName = primaryTableName;
            this.option = option;
            this.resultInfo = resultInfo;
            this.parse();
        }

        private void parse() {
            List<DWCascadeDeletingInfo> allSetting = this.option.getCascadingDeletingList();
            this.deleteList = allSetting.stream().filter(item -> this.primaryTableName.equals(item.getPrimary())).collect(Collectors.toList());
            if (this.deleteList.size() > 0) {
                DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)this.primaryTableName, DWRdbmsMetadata.class);
                this.relations = metadata.getAttributes(DWRdbmsRelationshipAttribute.class);
            }
        }

        private boolean hasReferenceCascadeSetting() {
            return this.deleteList.size() > 0;
        }

        private List<DWCascadeDeletingInfo> getCascadeDeletingList() {
            return this.deleteList;
        }

        private DWRdbmsRelationshipAttribute getMappingAttribute(DWCascadeDeletingInfo cascadTarget) {
            if (this.relations == null) {
                throw new DWDataException("13017", String.format("This table(%s) has no any cascade deleting setting!", this.primaryTableName));
            }
            String referenceName = cascadTarget.getReference();
            DWRdbmsRelationshipAttribute targetAttribute = this.relations.stream().filter(attr -> attr.getDetailTableName().equals(referenceName)).findFirst().get();
            if (targetAttribute == null) {
                throw new DWDataException("13018", String.format("cascade Query reference(%s) is not found in metadata", referenceName));
            }
            return targetAttribute;
        }
    }
}

