/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class DWQueryInfoBuilder {
    private String primaryKeyName;
    private List<Object> oids;

    public static DWQueryInfo create(List<Object> oids) {
        DWQueryInfoBuilder builder = new DWQueryInfoBuilder();
        builder.setOids(oids);
        return builder.create();
    }

    public void buildInFixedCondition(DWQueryInfo queryInfo) {
        DWQueryCondition condition = queryInfo.getFixedCondition();
        this.buildCondition(queryInfo.getFixedCondition(), this.oids);
    }

    public DWQueryInfo create() {
        DWQueryInfo queryInfo = new DWQueryInfo();
        if (this.oids == null) {
            return queryInfo;
        }
        this.buildCondition(queryInfo.getCondition(), this.oids);
        return queryInfo;
    }

    private void buildCondition(DWQueryCondition condition, List<Object> oids) {
        if (oids == null) {
            return;
        }
        if (oids.size() == 1) {
            this.buildCondition(condition, oids.get(0));
        } else {
            DWQueryCondition oidsCondition = new DWQueryCondition().ORJoin();
            oids.stream().forEach(oid -> this.buildCondition(oidsCondition, oid));
            condition.addCondition(oidsCondition);
        }
    }

    private void buildCondition(DWQueryCondition condition, Object oid) {
        if (oid instanceof Map) {
            Map mapOid = (Map)oid;
            if (mapOid.size() == 1) {
                Map.Entry firstEntry = mapOid.entrySet().iterator().next();
                condition.addEqualInfo((String)firstEntry.getKey(), firstEntry.getValue());
            } else {
                DWQueryCondition singleOidCondition = new DWQueryCondition();
                for (Map.Entry item : mapOid.entrySet()) {
                    singleOidCondition.addEqualInfo((String)item.getKey(), item.getValue());
                }
                condition.addCondition(singleOidCondition);
            }
        } else {
            if (this.primaryKeyName == null || this.primaryKeyName.isEmpty()) {
                throw new IllegalArgumentException("oid is not Map, so primaryKeyName can not be null or empty!");
            }
            condition.addEqualInfo(this.primaryKeyName, oid);
        }
    }

    public DWQueryInfoBuilder setOid(Object oid) {
        this.oids = Arrays.asList(oid);
        return this;
    }

    public DWQueryInfoBuilder setOids(List<Object> oids) {
        this.oids = oids;
        return this;
    }

    public DWQueryInfoBuilder setPrimaryKeyName(String name) {
        this.primaryKeyName = name;
        return this;
    }
}

