/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.data.DWCascadeDeletingInfo;
import com.digiwin.app.data.DWCascadeQueryInfo;
import com.digiwin.app.data.DWDataSetInsertOption;
import com.digiwin.utils.DWTenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DWDataSetOperationOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DWDataSetInsertOption insertOption = null;
    private List<DWCascadeQueryInfo> cascadeQueries = new ArrayList<DWCascadeQueryInfo>();
    private List<DWCascadeDeletingInfo> cascadeDeletings = new ArrayList<DWCascadeDeletingInfo>();
    private boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private boolean selectVersionFieldEnabled = false;
    private boolean relatedTableTenantEnabled = DWTenantUtils.isTenantenabled();
    private boolean calculateMaxSeqEnabled = false;
    private String calculateMaxSeqFieldName = null;

    public DWDataSetOperationOption() {
        String definedSelectVersionFieldEnabled = DWApplicationConfigUtils.getProperty((String)"dwdaoSelectVersionFieldEnabled", (String)"false");
        String definedCalculateMaxSeqEnabled = DWApplicationConfigUtils.getProperty((String)"dwdaoCalculateMaxSeqEnabled", (String)"false");
        this.calculateMaxSeqFieldName = DWApplicationConfigUtils.getProperty((String)"dwdaoCalculateMaxSeqFieldName", (String)"seq");
        if ("true".equals(definedSelectVersionFieldEnabled)) {
            this.selectVersionFieldEnabled = true;
        }
        if ("true".equals(definedCalculateMaxSeqEnabled)) {
            this.calculateMaxSeqEnabled = true;
        }
    }

    public DWDataSetOperationOption setInsertOperation(DWDataSetInsertOption insertOption) {
        this.insertOption = insertOption;
        return this;
    }

    public DWDataSetInsertOption getInsertOption() {
        if (this.insertOption == null) {
            this.insertOption = new DWDataSetInsertOption();
        }
        return this.insertOption;
    }

    public DWCascadeQueryInfo addCascadeQuery(String referenceTableName) {
        return this.addCascadeQuery(null, referenceTableName);
    }

    public DWCascadeQueryInfo addCascadeQuery(String primaryTableName, String referenceTableName) {
        DWCascadeQueryInfo queryInfo = new DWCascadeQueryInfo(primaryTableName, referenceTableName);
        this.cascadeQueries.add(queryInfo);
        return queryInfo;
    }

    public DWCascadeDeletingInfo addCascadeDeleting(String referenceTableName) {
        return this.addCascadeDeleting(null, referenceTableName);
    }

    public DWCascadeDeletingInfo addCascadeDeleting(String primaryTableName, String referenceTableName) {
        DWCascadeDeletingInfo deletingInfo = new DWCascadeDeletingInfo(primaryTableName, referenceTableName);
        this.cascadeDeletings.add(deletingInfo);
        return deletingInfo;
    }

    public List<DWCascadeQueryInfo> getCascadingQueryList() {
        return this.cascadeQueries;
    }

    public List<DWCascadeDeletingInfo> getCascadingDeletingList() {
        return this.cascadeDeletings;
    }

    public boolean isTenantEnabled() {
        return this.tenantEnabled;
    }

    public void setTenantEnabled(boolean tenantEnabled) {
        this.tenantEnabled = tenantEnabled;
    }

    public boolean isRelatedTableTenantEnabled() {
        return this.relatedTableTenantEnabled;
    }

    public void setRelatedTableTenantEnabled(boolean relatedTableTenantEnabled) {
        this.relatedTableTenantEnabled = relatedTableTenantEnabled;
    }

    public void setSelectVersionFieldEnabled(boolean selectVersionFieldEnabled) {
        this.selectVersionFieldEnabled = selectVersionFieldEnabled;
    }

    public boolean isSelectVersionFieldEnabled() {
        return this.selectVersionFieldEnabled;
    }

    public void setCalculateMaxSeqEnabled(boolean calculateMaxSeqEnabled) {
        this.calculateMaxSeqEnabled = calculateMaxSeqEnabled;
    }

    public boolean isCalculateMaxSeqEnabled() {
        return this.calculateMaxSeqEnabled;
    }

    public void setCalculateMaxSeqFieldName(String calculateMaxSeqFieldName) {
        this.calculateMaxSeqFieldName = calculateMaxSeqFieldName;
    }

    public String getCalculateMaxSeqFieldName() {
        return this.calculateMaxSeqFieldName;
    }
}

