/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWOnCondition;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryJoin;
import com.digiwin.app.dao.DWQueryJoinOnColumn;
import com.digiwin.app.dao.DWQueryJoinOnCondition;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWQueryValueOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DWQueryInfo
implements Serializable {
    private String tableName;
    private DWQueryCondition condition = new DWQueryCondition();
    private DWQueryCondition fixedCondition = new DWQueryCondition();
    private List<DWQueryOrderby> orderfields = new ArrayList<DWQueryOrderby>();
    private List<DWQueryJoin> joins = new LinkedList<DWQueryJoin>();
    private Map<String, Set<String>> joinTableSelectFields = new HashMap<String, Set<String>>();
    private boolean distinct = false;
    private List<String> selectFields;
    private boolean selectAll = false;

    public DWQueryInfo setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public DWQueryInfo() {
    }

    public DWQueryInfo(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.condition.setTableName(this.tableName);
        this.tableName = tableName;
    }

    public DWQueryCondition getCondition() {
        return this.condition;
    }

    public DWQueryInfo setCondition(DWQueryCondition condition) {
        if (condition == null) {
            condition = new DWQueryCondition();
        }
        condition.setTableName(this.tableName);
        this.condition = condition;
        return this;
    }

    public DWQueryCondition getFixedCondition() {
        return this.fixedCondition;
    }

    public DWQueryInfo setFixedCondition(DWQueryCondition condition) {
        if (condition == null) {
            condition = new DWQueryCondition();
        }
        this.fixedCondition = condition;
        return this;
    }

    public DWQueryInfo toOR() {
        this.condition.OR();
        return this;
    }

    public List<DWQueryOrderby> getOrderfields() {
        return this.orderfields;
    }

    public DWQueryInfo addFieldInfo(String name, DWQueryValueOperator operator, Object ... values) {
        this.condition.addFieldInfo(name, operator, values);
        return this;
    }

    public DWQueryInfo addEqualInfo(String name, Object value) {
        this.condition.addEqualInfo(name, value);
        return this;
    }

    public DWQueryInfo addBetweenInfo(String name, Object value1, Object value2) {
        this.condition.addBetweenInfo(name, value1, value2);
        return this;
    }

    public List<String> getSelectFields() {
        return this.selectFields;
    }

    @Deprecated
    public void setSelectFields(List<String> selectFields) {
        this.selectFields = selectFields;
    }

    public DWQueryInfo setSelectFields(String ... fields) {
        this.selectFields = Arrays.asList(fields);
        return this;
    }

    public DWQueryInfo removeSelectFields(String field) {
        this.selectFields.remove(field);
        return this;
    }

    public void setOrderfields(List<DWQueryOrderby> orderfields) {
        this.orderfields = orderfields;
    }

    public DWQueryInfo addOrderBy(String name) {
        return this.addOrderBy(name, true);
    }

    public DWQueryInfo addOrderBy(String name, boolean ascending) {
        DWQueryOrderby field = new DWQueryOrderby(name);
        if (ascending) {
            field.setOrderby(DWQueryOrderby.SORT_ASCENDING);
        } else {
            field.setOrderby(DWQueryOrderby.SORT_DESCENDING);
        }
        this.orderfields.add(field);
        return this;
    }

    public List<DWQueryOrderby> addSuffixOrderby(String name, String orderby) {
        this.orderfields.add(new DWQueryOrderby(name, orderby));
        return this.orderfields;
    }

    public List<DWQueryOrderby> addPrefixOrderby(String name, String orderby) {
        this.orderfields.add(0, new DWQueryOrderby(name, orderby));
        return this.orderfields;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public DWQueryInfo setJoin(DWQueryJoin queryJoin) {
        this.joins.add(queryJoin);
        return this;
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, String relationTableName, DWOnColumn ... ons) {
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTableName, relationTableName, ons);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, DWOnColumn ... ons) {
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTableName, this.tableName, ons);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, String relationTableName, String joinTableField, DWQueryValueOperator operator, String relationTableField) {
        DWOnColumn on = new DWOnColumn(joinTableField, operator, relationTableField);
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTableName, relationTableName, on);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, String joinTableField, DWQueryValueOperator operator, String relationTableField) {
        DWOnColumn on = new DWOnColumn(joinTableField, operator, relationTableField);
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTableName, this.tableName, on);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnCondition(DWQueryJoinRelation relation, String joinTableName, DWOnCondition ... ons) {
        DWQueryJoinOnCondition queryJoin = new DWQueryJoinOnCondition(relation, joinTableName, ons);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnCondition(DWQueryJoinRelation relation, String joinTableName, String conditionTableName, String conditionFieldName, DWQueryValueOperator operator, Object ... values) {
        DWOnCondition on = new DWOnCondition(conditionTableName, conditionFieldName, operator, values);
        DWQueryJoinOnCondition queryJoin = new DWQueryJoinOnCondition(relation, joinTableName, on);
        return this.setJoin(queryJoin);
    }

    public Set<String> getJoinTableSelectField(String joinTableName) {
        Set set = this.joinTableSelectFields.getOrDefault(joinTableName, new HashSet());
        return set;
    }

    public DWQueryInfo addJoinTableSelectField(String joinTableName, String ... selectFields) {
        Set set = this.joinTableSelectFields.getOrDefault(joinTableName, new HashSet());
        for (String selectField : selectFields) {
            set.add(selectField);
        }
        this.joinTableSelectFields.put(joinTableName, set);
        return this;
    }

    public List<DWQueryJoin> getJoin() {
        return this.joins;
    }

    public void setJoin(List<DWQueryJoin> joins) {
        this.joins = joins;
    }
}

