/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data.validation;

import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.validation.DWVDTable;
import com.digiwin.app.data.validation.DWVDTables;
import com.digiwin.app.resource.DWApplicationMessageResourceBundleUtils;
import com.digiwin.app.validation.DWConstraintViolationException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.util.StringUtils;

public class DWDataTablesValidator
implements ConstraintValidator<DWVDTables, DWDataSet> {
    private Map<String, Set<String>> allowedTables;

    public void initialize(DWVDTables constraintAnnotation) {
        DWVDTable[] tables = constraintAnnotation.value();
        DWDataTablesValidator.validateParameters(tables);
        this.allowedTables = Arrays.stream(tables).collect(Collectors.toMap(item -> item.name().toLowerCase(), item -> Arrays.stream(item.operations()).map(o -> o == null ? null : o.toLowerCase()).collect(Collectors.toSet())));
    }

    public boolean isValid(DWDataSet value, ConstraintValidatorContext context) {
        return DWDataTablesValidator.isValid(this.allowedTables, value, context);
    }

    static void validateParameters(DWVDTable[] tables) {
        if (tables == null) {
            return;
        }
        Arrays.stream(tables).forEach(table -> DWDataTablesValidator.validateParameters(table));
    }

    private static void validateParameters(DWVDTable table) {
        if (table == null) {
            return;
        }
        if (StringUtils.isEmpty((Object)table.name())) {
            throw new IllegalArgumentException("DWVDTable name is null or empty!");
        }
    }

    static boolean isValid(Map<String, Set<String>> allowedTables, DWDataSet value, ConstraintValidatorContext context) {
        boolean valid = true;
        if (value == null) {
            return true;
        }
        String[] tableNames = value.getTables().getNames();
        Set notAllowedNames = Arrays.stream(tableNames).filter(name -> StringUtils.isEmpty((Object)name) || !allowedTables.containsKey(name.toLowerCase())).collect(Collectors.toSet());
        if (notAllowedNames.size() > 0) {
            String errorCode = DWConstraintViolationException.ERROR_CODE + "_1";
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)errorCode, (Object[])new Object[]{notAllowedNames});
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            context.disableDefaultConstraintViolation();
            return false;
        }
        Iterator<DWDataTable> iterator = value.getTables().iterator();
        HashMap notAllowedOperations = new HashMap();
        while (iterator.hasNext()) {
            DWDataTable table = iterator.next();
            Set<String> allowedOperations = allowedTables.get(table.getName().toLowerCase());
            Set invalidOperations = table.getRows().stream().map(r -> r.getState()).filter(state -> {
                if ("".equalsIgnoreCase((String)state)) {
                    return false;
                }
                return !allowedOperations.contains(state.toLowerCase());
            }).collect(Collectors.toSet());
            Iterator<DWDataRow> iteratorOfRemovedRows = table.getRows().getIteratorOfRemovedRows();
            while (iteratorOfRemovedRows.hasNext()) {
                String rowState = iteratorOfRemovedRows.next().getState();
                if ("".equalsIgnoreCase(rowState) || allowedOperations.contains(rowState.toLowerCase())) continue;
                invalidOperations.add(rowState);
            }
            if (invalidOperations.size() <= 0) continue;
            String errorCode = DWConstraintViolationException.ERROR_CODE + "_2";
            String errorMessage = DWApplicationMessageResourceBundleUtils.getString((String)errorCode, (Object[])new Object[]{invalidOperations});
            context.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            context.disableDefaultConstraintViolation();
            return false;
        }
        return true;
    }
}

