/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.data.DWDataSet;
import java.io.Serializable;

public class DWPaginationQueryResult
implements Serializable {
    private long rowCount;
    private long pageCount;
    private int pageSize = 5;
    private int currentPage = 1;
    private DWDataSet data;

    public DWPaginationQueryResult(int pageSize, long rowCount) {
        this.pageSize = pageSize;
        this.rowCount = rowCount;
        this.pageCount = rowCount == 0L ? 0L : (rowCount - 1L) / (long)pageSize + 1L;
        this.currentPage = rowCount > 0L ? 1 : 0;
    }

    public void setCurrentPage(int currentPage, DWDataSet datas) {
        if (currentPage < 0) {
            throw new IllegalArgumentException("pageSize must be greater than zero");
        }
        this.currentPage = currentPage;
        this.data = datas;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public DWDataSet getDataSet() {
        return this.data;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setDataSet(DWDataSet dataset) {
        this.data = dataset;
    }
}

