/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.data.DWDataRow;
import java.util.HashMap;
import java.util.Map;

public final class DWDataRowInfoUtils {
    public static final String COLUMN_NAME_ROW_INFO = "$info";
    public static final String INFO_KEY_CHILDS_INFO = "child";
    public static final String INFO_KEY_SEQ_NAME = "seqName";
    public static final String INFO_KEY_MAX_SEQ = "maxSeq";
    public static final String INFO_KEY_ROW_COUNT = "rowCount";
    public static final String INFO_KEY_PAGE_SIZE = "pageSize";
    public static final String INFO_KEY_PAGE_COUNT = "pageCount";
    public static final String INFO_KEY_CURRENT_PAGE = "currentPage";

    public static Map<String, Object> getInfoMap(DWDataRow row) {
        HashMap info = (HashMap)row.get(COLUMN_NAME_ROW_INFO);
        if (info == null) {
            info = new HashMap();
            row.set(COLUMN_NAME_ROW_INFO, info);
        }
        return info;
    }

    public static Map<String, Object> getChildsInfoMap(DWDataRow row) {
        Map<String, Object> infoMap = DWDataRowInfoUtils.getInfoMap(row);
        HashMap childsMap = (HashMap)infoMap.get(INFO_KEY_CHILDS_INFO);
        if (childsMap == null) {
            childsMap = new HashMap();
            infoMap.put(INFO_KEY_CHILDS_INFO, childsMap);
        }
        return childsMap;
    }

    public static Map<String, Object> getChildInfo(DWDataRow row, String detailTableName) {
        Map<String, Object> childsMap = DWDataRowInfoUtils.getChildsInfoMap(row);
        HashMap detailInfo = (HashMap)childsMap.get(detailTableName);
        if (detailInfo == null) {
            detailInfo = new HashMap();
            childsMap.put(detailTableName, detailInfo);
        }
        return detailInfo;
    }

    public static Map<String, Object> setChildSeqInfo(DWDataRow row, String detailTableName, String seqName, long maxSeq) {
        Map<String, Object> detailInfo = DWDataRowInfoUtils.getChildInfo(row, detailTableName);
        detailInfo.put(INFO_KEY_SEQ_NAME, seqName);
        detailInfo.put(INFO_KEY_MAX_SEQ, maxSeq);
        return detailInfo;
    }

    public static Map<String, Object> setChildPageInfo(DWDataRow row, String detailTableName, DWPaginationQueryResult paginationResult) {
        Map<String, Object> detailInfo = DWDataRowInfoUtils.getChildInfo(row, detailTableName);
        detailInfo.put(INFO_KEY_ROW_COUNT, paginationResult.getRowCount());
        detailInfo.put(INFO_KEY_PAGE_SIZE, paginationResult.getPageSize());
        detailInfo.put(INFO_KEY_PAGE_COUNT, paginationResult.getPageCount());
        detailInfo.put(INFO_KEY_CURRENT_PAGE, paginationResult.getCurrentPage());
        return detailInfo;
    }
}

