/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import java.io.Serializable;

public class DWPaginationQueryBaseResult<T>
implements Serializable {
    private long rowCount;
    private long pageCount;
    private int pageSize = 5;
    private int currentPage = 1;
    private T data;

    public DWPaginationQueryBaseResult(int pageSize, long rowCount) {
        this.pageSize = pageSize;
        this.rowCount = rowCount;
        this.pageCount = rowCount == 0L ? 0L : (rowCount - 1L) / (long)pageSize + 1L;
        this.currentPage = rowCount > 0L ? 1 : 0;
    }

    public void setCurrentPage(int currentPage, T data) {
        if (currentPage < 0) {
            throw new IllegalArgumentException("currentPage must be greater than zero");
        }
        this.currentPage = currentPage;
        this.data = data;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

