/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.dao.filter.IDWManagementFieldResolver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DWAbstractManagementFieldResolver
implements IDWManagementFieldResolver {
    private Map<String, String> insertMappings = new LinkedHashMap<String, String>();
    private Map<String, String> updateMappings = new LinkedHashMap<String, String>();

    DWAbstractManagementFieldResolver() {
        String rawInsertMappings = DWApplicationConfigUtils.getProperty((String)"mgmtFieldInsertMappings");
        String rawUpdateMappings = DWApplicationConfigUtils.getProperty((String)"mgmtFieldUpdateMappings");
        this.initMappins(rawInsertMappings, this.insertMappings);
        this.initMappins(rawUpdateMappings, this.updateMappings);
    }

    private void initMappins(String mappingsSetting, Map<String, String> targetMappings) {
        if (mappingsSetting != null) {
            String[] parts;
            for (String part : parts = mappingsSetting.split(",")) {
                String mappingKeyForValue;
                String dbFieldName;
                if (part.trim().length() == 0) continue;
                int tempIndex = part.indexOf(":");
                if (tempIndex == -1) {
                    mappingKeyForValue = dbFieldName = part;
                } else {
                    dbFieldName = part.substring(0, tempIndex);
                    mappingKeyForValue = part.substring(tempIndex + 1);
                }
                targetMappings.put(dbFieldName, mappingKeyForValue);
            }
        }
    }

    @Override
    public String[] getInsertFields() {
        Set<String> keys = this.insertMappings.keySet();
        String[] array = keys.toArray(new String[keys.size()]);
        return array;
    }

    @Override
    public String[] getUpdateFields() {
        Set<String> keys = this.updateMappings.keySet();
        String[] array = keys.toArray(new String[keys.size()]);
        return array;
    }

    @Override
    public Object getFieldValue(String fieldName) {
        String mappingKey = this.insertMappings.get(fieldName);
        if (mappingKey == null) {
            mappingKey = this.updateMappings.get(fieldName);
        }
        Object value = this.getFieldValue(fieldName, mappingKey);
        return value;
    }

    protected abstract Object getFieldValue(String var1, String var2);

    @Override
    public List<Object> getInsertFieldValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String fieldName : this.insertMappings.keySet()) {
            values.add(this.getFieldValue(fieldName));
        }
        return values;
    }

    @Override
    public List<Object> getUpdateFieldValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String fieldName : this.updateMappings.keySet()) {
            values.add(this.getFieldValue(fieldName));
        }
        return values;
    }
}

