/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.filter;

import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryElement;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.filter.IDWSQLFilter;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.utils.DWTenantUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWSQLTenantIsolationFilter
implements IDWSQLFilter {
    public static String OPTION_TENANT_ENABLED = "tenantEnabled";
    private static Log log = LogFactory.getLog(DWSQLTenantIsolationFilter.class);
    private static boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private static String tenantColumnName = DWTenantUtils.getTenantColumnName();
    private static String IAM_TENANTSIDKEY = DWTenantUtils.getIAMTenantSidKey();
    private static String IAM_TENANTSID = DWTenantUtils.getIAMTenantSidKey();
    private static String sqlTenantTag = DWTenantUtils.getTenantTagByColumnName();
    private static String sqlTenantNameTag = DWTenantUtils.getSqlTenantNameTag();
    private static String sqlTenantValueTag = DWTenantUtils.getSqlTenantValueTag();
    private static String sqlIgnoreTenantTag = DWTenantUtils.getTenantIgnoreTagByColumnName();
    private static String sqlIgnoreTenantNameTag = DWTenantUtils.getSqlIgnoreTenantNameTag();
    private static String sqlIgnoreTenantValueTag = DWTenantUtils.getSqlIgnoreTenantValueTag();
    private static final String _matchQuoteEmpty = Matcher.quoteReplacement(" ");

    public static void disableInOptions(IDWSQLOptions options) {
        DWSQLTenantIsolationFilter.setEnabledInOptions(options, false);
    }

    public static void setEnabledInOptions(IDWSQLOptions options, boolean enabled) {
        options.set(OPTION_TENANT_ENABLED, tenantEnabled);
    }

    public static boolean isEnabled(IDWSQLOptions options) {
        if (options == null) {
            return tenantEnabled;
        }
        boolean enabled = options.get(OPTION_TENANT_ENABLED, tenantEnabled);
        return enabled;
    }

    @Override
    public void doFilter(DWSqlInfo sqlInfo, IDWSQLOptions options) {
        String sqlcommand = sqlInfo.getSql();
        List<Object> parameters = sqlInfo.getParametersAsList();
        log.debug((Object)("[DWSQLTenantIsolationFilter.doFilter] TenantEnabled:" + tenantEnabled + ",before sql command:" + sqlcommand));
        if (DWSQLTenantIsolationFilter.isEnabled(options)) {
            Map profile = DWServiceContext.getContext().getProfile();
            if (profile.containsKey(IAM_TENANTSIDKEY)) {
                Long tenantSid = (Long)profile.get(IAM_TENANTSIDKEY);
                if (sqlcommand.contains(sqlTenantTag) || sqlcommand.contains(sqlTenantNameTag) || sqlcommand.contains(sqlTenantValueTag)) {
                    sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantTag), _matchQuoteEmpty);
                    sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantNameTag), _matchQuoteEmpty);
                    if ((sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantValueTag), _matchQuoteEmpty)).contains(sqlTenantTag)) {
                        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantTag), Matcher.quoteReplacement(" and " + tenantColumnName + "= " + tenantSid + " "));
                    }
                    if (sqlcommand.contains(sqlTenantNameTag)) {
                        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantNameTag), Matcher.quoteReplacement(", " + tenantColumnName));
                    }
                    if (sqlcommand.contains(sqlTenantValueTag)) {
                        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantValueTag), Matcher.quoteReplacement(", " + tenantSid + " "));
                    }
                    sqlInfo.setSqlAndParameters(sqlcommand, parameters);
                    log.debug((Object)("[DWSQLTenantIsolationFilter.doFilter] after sql command:" + sqlcommand));
                    return;
                }
                throw new DWDataException("13014", String.format("[DWSQLTenantIsolationFilter.doFilter] related tenant tag(%s/%s/%s) is missing in sqlcommand.", sqlTenantTag, sqlTenantNameTag, sqlTenantValueTag));
            }
            if (!sqlcommand.contains(sqlIgnoreTenantTag)) {
                throw new DWDataException("13012", String.format("[DWSQLTenantIsolationFilter.doFilter] %s is missing in profile.", tenantColumnName));
            }
        }
        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantTag), _matchQuoteEmpty);
        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantNameTag), _matchQuoteEmpty);
        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlIgnoreTenantValueTag), _matchQuoteEmpty);
        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantTag), _matchQuoteEmpty);
        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantNameTag), _matchQuoteEmpty);
        sqlcommand = sqlcommand.replaceAll(Pattern.quote(sqlTenantValueTag), _matchQuoteEmpty);
        sqlInfo.setSqlAndParameters(sqlcommand, parameters);
        log.debug((Object)("[DWSQLTenantIsolationFilter.doFilter][non-tenant] after sql command:" + sqlcommand));
    }

    private boolean isTenantDisabled(String tableName, IDWSQLOptions options) {
        if (options == null || tableName == null) {
            return false;
        }
        return options.get(DWSQLOptionsBuilder.OPTION_TENANT_DISABLED_TABLE_NAMES, Collections.EMPTY_LIST).stream().anyMatch(tableName::equalsIgnoreCase);
    }

    @Override
    public void doFilterOthers(Object otherObject, IDWSQLOptions options) {
        if (!DWSQLTenantIsolationFilter.isEnabled(options)) {
            return;
        }
        Join join = null;
        Table joinTable = null;
        if (otherObject instanceof Join) {
            join = (Join)otherObject;
            if (join.getRightItem() instanceof Table) {
                joinTable = (Table)join.getRightItem();
            }
        } else {
            return;
        }
        if (joinTable != null && this.isTenantDisabled(joinTable.getName(), options)) {
            return;
        }
        Map profile = DWServiceContext.getContext().getProfile();
        Object tenantSidValue = profile.get(IAM_TENANTSID);
        Column tenantSidColumn = new Column(joinTable, tenantColumnName);
        EqualsTo tenantColumnExpression = new EqualsTo();
        tenantColumnExpression.setLeftExpression((Expression)tenantSidColumn);
        tenantColumnExpression.setRightExpression((Expression)new LongValue(tenantSidValue.toString()));
        AndExpression expressionWithTenantsidCondition = new AndExpression(join.getOnExpression(), (Expression)tenantColumnExpression);
        join.setOnExpression((Expression)expressionWithTenantsidCondition);
    }

    @Override
    public void doFilter(DWQueryInfo queryInfo, IDWSQLOptions options) {
        if (!DWSQLTenantIsolationFilter.isEnabled(options) || queryInfo.getFromInfo() != null || this.isTenantDisabled(queryInfo.getTableName(), options)) {
            return;
        }
        DWQueryCondition fixedCondition = queryInfo.getFixedCondition();
        boolean isExistTenantCondition = false;
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile.containsKey(IAM_TENANTSID)) {
            String tableName = queryInfo.getTableName();
            String tenantFullColunmName = tenantColumnName;
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                tenantFullColunmName = tableName + "." + tenantColumnName;
            }
            if (fixedCondition != null && fixedCondition.size() > 0) {
                for (DWQueryElement element : fixedCondition.getItems()) {
                    DWQueryField field;
                    if (!(element instanceof DWQueryField) || !(field = (DWQueryField)element).getName().equals(tenantFullColunmName)) continue;
                    isExistTenantCondition = true;
                }
            }
            if (!isExistTenantCondition) {
                fixedCondition.addEqualInfo(tenantFullColunmName, profile.get(IAM_TENANTSID));
            }
        } else {
            throw new DWDataException("13013", String.format("[DWDAO]DWSQLTenantIsolationFilter.doFilter: %s is missing in profile", IAM_TENANTSID));
        }
    }

    @Override
    public void doFilter(DWDataRow dataRow, IDWSQLOptions options) {
        if (!DWSQLTenantIsolationFilter.isEnabled(options)) {
            return;
        }
        if (!dataRow.getData().containsKey(tenantColumnName)) {
            Map profile = DWServiceContext.getContext().getProfile();
            if (profile.containsKey(IAM_TENANTSID)) {
                Long tenantSid = (Long)profile.get(IAM_TENANTSID);
                dataRow.set(tenantColumnName, (Object)tenantSid);
            } else {
                throw new DWDataException("13012", String.format("[DWDAO]DWSQLTenantIsolationFilter.doFilter: %s is missing in profile", IAM_TENANTSID));
            }
        }
    }
}

