/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.sql.DaoExceptionFactory;
import com.digiwin.app.sql.IDaoException;
import java.sql.SQLException;
import java.util.List;

public class DWSQLExceptionHandler {
    public static final int DEPTH_OF_CAUSE = 4;

    public static void handle(Exception source, Object data, DWDao dao) throws Exception {
        try {
            SQLException queryException = DWSQLExceptionHandler.findSQLException(source);
            if (queryException == null) {
                DWSQLExceptionHandler.handlePersistenceException(source);
            } else {
                DWSQLExceptionHandler.handleQueryException(queryException, data, dao);
            }
        }
        catch (DWBusinessException resultException) {
            throw resultException;
        }
        catch (Exception handleException) {
            source.addSuppressed(handleException);
            throw source;
        }
    }

    public static SQLException findSQLException(Exception target) throws Exception {
        SQLException result = null;
        Throwable currentCause = target;
        for (int i = 0; i < 4; ++i) {
            if (currentCause instanceof SQLException) {
                result = (SQLException)currentCause;
                break;
            }
            if ((currentCause = currentCause.getCause()) == null) break;
        }
        return result;
    }

    public static void handlePersistenceException(Exception target) throws Exception {
        DWBusinessException persistentException = new DWBusinessException("[\u8d44\u6599\u5904\u7406\u5f02\u5e38]", (Throwable)target);
        throw persistentException;
    }

    public static void handleQueryException(SQLException target, Object data, DWDao dao) throws Exception {
        int errorCode = target.getErrorCode();
        String exceptionMessage = target.getMessage().replace("\r", " ").replace("\n", " ").replace("\t", "");
        List<IDaoException> daoExceptions = DaoExceptionFactory.getDaoExceptions();
        for (IDaoException daoException : daoExceptions) {
            if (errorCode != daoException.getErrorCode()) continue;
            exceptionMessage = daoException.handle(exceptionMessage, data, dao);
        }
        DWBusinessException queryException = new DWBusinessException(exceptionMessage, (Throwable)target);
        throw queryException;
    }
}

