/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.sql;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.sql.BaseDaoException;
import com.digiwin.app.sql.SQLParser;

public class UnknownColumnException
extends BaseDaoException {
    public static final int ERROR_CODE = 1054;
    public static final String UNKNOWN_COLUMN_PREFIX = "Unknown column '";
    public static final String UNKNOWN_COLUMN_POSTFIX = "' in";
    public static final int UNKNOWN_COLUMN_PREFIX_INDEX = "Unknown column '".length();

    @Override
    public int getErrorCode() throws Exception {
        return 1054;
    }

    @Override
    public void settingFormat(String message, DWDao dao) throws Exception {
        this.exceptionMessageFormat = "[\u8d44\u6599\u5904\u7406\u5f02\u5e38][\u5b57\u6bb5\u4e0d\u5b58\u5728]\u8d44\u6599\u8868=%s(%s)\uff0c\u5b57\u6bb5=%s";
    }

    @Override
    public void settingArgument(String message, DWDao dao) throws Exception {
        String tableName = SQLParser.fetchTableName(message);
        String columnName = this.fetchMessage(message);
        DWRdbmsMetadata metadata = this.getMetadata(tableName);
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(metadata.getName());
        this.exceptionMessageArgument.add(columnName);
    }

    private String fetchMessage(String message) throws Exception {
        String result = "";
        int leftIndex = message.indexOf(UNKNOWN_COLUMN_PREFIX) + UNKNOWN_COLUMN_PREFIX_INDEX;
        int rightIndex = message.indexOf(UNKNOWN_COLUMN_POSTFIX);
        result = message.substring(leftIndex, rightIndex);
        return result;
    }
}

