/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.generic;

import com.digiwin.app.dao.DWBatchDataRowSqlInfo;
import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.dao.DWDataSetSqlInfo;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.basic.DWDataSetOperationOptionBuilder;
import com.digiwin.app.dao.constraint.DWDeleteConstraint;
import com.digiwin.app.dao.generic.DWDataSetDao;
import com.digiwin.app.dao.generic.DWDataTableHandler;
import com.digiwin.app.dao.generic.DWGenericDaoImpl;
import com.digiwin.app.data.DWCascadeDeletingInfo;
import com.digiwin.app.data.DWCascadeQueryInfo;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCondition;
import com.digiwin.app.data.DWDataRowInfoUtils;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.data.exceptions.DWDataOptimisticLockingException;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWDataSetDaoImpl
extends DWGenericDaoImpl
implements DWDataSetDao {
    private static Log log = LogFactory.getLog(DWDataSetDaoImpl.class);
    private boolean insertDefaultValueFromMetadata = false;
    private boolean updateDefaultValueFromMetadata = false;
    private boolean queryPaginationByObjectEnabled = true;

    public DWDataSetDaoImpl(QueryRunner queryRunner) {
        super(queryRunner);
    }

    public void setInsertDefaultValueFromMetadata(boolean insertDefaultValueFromMetadata) {
        this.insertDefaultValueFromMetadata = insertDefaultValueFromMetadata;
    }

    public void setUpdateDefaultValueFromMetadata(boolean updateDefaultValueFromMetadata) {
        this.updateDefaultValueFromMetadata = updateDefaultValueFromMetadata;
    }

    public void setQueryPaginationByObjectEnabled(boolean enabled) {
        this.queryPaginationByObjectEnabled = enabled;
    }

    @Override
    @Deprecated
    public DWDataSet select(DWQueryInfo queryInfo, String sql) {
        return this.select(queryInfo, sql, null);
    }

    @Override
    @Deprecated
    public DWDataSet select(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        if (option == null) {
            option = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        if (this.queryPaginationByObjectEnabled && queryInfo instanceof DWPagableQueryInfo) {
            DWPaginationQueryResult result = this.selectWithPage((DWPagableQueryInfo)queryInfo, sql, option);
            return (DWDataSet)result.getData();
        }
        DWDataTableHandler dwDataTableHandler = new DWDataTableHandler(queryInfo);
        DWDataTable dataTable = this.select(queryInfo, sql, option, dwDataTableHandler);
        this.cascadeSelect(dataTable, option);
        return dataTable.getDataSet();
    }

    @Override
    public DWDataSet select(DWQueryInfo queryInfo) {
        return this.select(queryInfo, null, null);
    }

    @Override
    public DWDataSet select(DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        return this.select(queryInfo, null, option);
    }

    private void cascadeSelect(DWDataTable dataTable, DWDataSetOperationOption option) {
        String primaryTableName = dataTable.getName();
        List<DWCascadeQueryInfo> queryList = option.getCascadingQueryList();
        if (queryList.size() == 0) {
            return;
        }
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)primaryTableName, DWRdbmsMetadata.class);
        Collection relations = metadata.getAttributes(DWRdbmsRelationshipAttribute.class);
        List cascadeList = queryList.stream().filter(item -> primaryTableName.equals(item.getPrimary())).collect(Collectors.toList());
        for (DWCascadeQueryInfo cascadTarget : cascadeList) {
            String referenceName = cascadTarget.getReference();
            DWRdbmsRelationshipAttribute targetAttribute = relations.stream().filter(attr -> attr.getDetailTableName().equals(referenceName)).findFirst().get();
            if (targetAttribute == null) {
                throw new DWDataException(String.format("cascade Query reference(%s) is not found in metadata", referenceName));
            }
            this.cascadeSelect(dataTable, cascadTarget, targetAttribute, option);
        }
    }

    private void cascadeSelect(DWDataTable dataTable, DWCascadeQueryInfo cascadeQueryInfo, DWRdbmsRelationshipAttribute relation, DWDataSetOperationOption option) {
        DWQueryInfo userdefinedQueryInfo = cascadeQueryInfo.getQueryInfo();
        dataTable.getRows().stream().forEach(row -> {
            boolean bl;
            DWRdbmsMetadata relationTableMetadata;
            boolean bl2;
            DWQueryInfo rowQueryInfo;
            boolean isPagableQueryInfo = userdefinedQueryInfo instanceof DWPagableQueryInfo;
            DWQueryInfo dWQueryInfo = rowQueryInfo = isPagableQueryInfo ? new DWPagableQueryInfo() : new DWQueryInfo();
            if (isPagableQueryInfo) {
                DWPagableQueryInfo userdefinedPagableQueryInfo = (DWPagableQueryInfo)userdefinedQueryInfo;
                DWQueryInfo dWQueryInfo2 = rowQueryInfo;
                ((DWPagableQueryInfo)dWQueryInfo2).setPageSize(userdefinedPagableQueryInfo.getPageSize());
                ((DWPagableQueryInfo)dWQueryInfo2).setPageNumber(userdefinedPagableQueryInfo.getPageNumber());
            }
            this.addRelationConditions((DWDataRow)row, relation, rowQueryInfo);
            rowQueryInfo.getOrderfields().addAll(userdefinedQueryInfo.getOrderfields());
            for (Object e : userdefinedQueryInfo.getSelectObjects()) {
                rowQueryInfo.addSelectField((String)e);
            }
            if (userdefinedQueryInfo.getCondition() != null) {
                DWQueryCondition userDefinedCondition = userdefinedQueryInfo.getCondition().clone();
                rowQueryInfo.getCondition().addCondition(userDefinedCondition);
            }
            String relationTableName = relation.getDetailTableName();
            boolean bl3 = bl2 = option.isCalculateMaxSeqEnabled() && option.getCalculateMaxSeqFieldName() != null && !option.getCalculateMaxSeqFieldName().isEmpty();
            if (bl2 && !(relationTableMetadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)relationTableName, DWRdbmsMetadata.class)).hasField(option.getCalculateMaxSeqFieldName())) {
                bl = false;
            }
            try {
                rowQueryInfo.setTableName(relation.getDetailTableName());
                DWDataSet referenceDataset = null;
                if (isPagableQueryInfo) {
                    DWPaginationQueryResult paginationResult = this.selectWithPage((DWPagableQueryInfo)rowQueryInfo, option);
                    referenceDataset = paginationResult.getDataSet();
                    DWDataRowInfoUtils.setChildPageInfo(row, relation.getDetailTableName(), paginationResult);
                    if (bl) {
                        DWQueryInfo queryMaxSqlInfo = new DWQueryInfo();
                        queryMaxSqlInfo.setTableName(relation.getDetailTableName());
                        queryMaxSqlInfo.setSelectFields("max(" + option.getCalculateMaxSeqFieldName() + ") as maxSeq");
                        this.addRelationConditions((DWDataRow)row, relation, queryMaxSqlInfo);
                        DWDataRow maxRow = this.selectOne(queryMaxSqlInfo, option);
                        Object maxSeqSourceValue = maxRow.get("maxSeq");
                        long maxSeq = maxSeqSourceValue == null ? 0L : Long.parseLong(maxSeqSourceValue.toString());
                        DWDataRowInfoUtils.setChildSeqInfo(row, relation.getDetailTableName(), option.getCalculateMaxSeqFieldName(), maxSeq);
                    }
                } else {
                    referenceDataset = this.select(rowQueryInfo, null, option);
                    if (bl) {
                        long maxSeq = this.getMaxSeqInTable(referenceDataset.getTable(relationTableName), option.getCalculateMaxSeqFieldName());
                        DWDataRowInfoUtils.setChildSeqInfo(row, relationTableName, option.getCalculateMaxSeqFieldName(), maxSeq);
                    }
                }
                row.set(relation.getDetailTableName(), (Object)referenceDataset);
            }
            catch (Exception e) {
                this.logStackTrace(e);
                throw new RuntimeException(e);
            }
        });
    }

    private long getMaxSeqInTable(DWDataTable table, String seqFieldName) {
        long maxSeq = 0L;
        long seqLongValue = 0L;
        for (DWDataRow row : table.getRows()) {
            Object seqValue = row.get(seqFieldName);
            if (seqValue == null || maxSeq >= (seqLongValue = Long.parseLong(seqValue.toString()))) continue;
            maxSeq = seqLongValue;
        }
        return maxSeq;
    }

    private void addRelationConditions(DWDataRow primaryRow, DWRdbmsRelationshipAttribute relationAttribute, DWQueryInfo referenceQueryInfo) {
        Map joinColumns = relationAttribute.getJoinColumns();
        for (Map.Entry item : joinColumns.entrySet()) {
            String primaryField = (String)item.getKey();
            String referenceField = (String)item.getValue();
            Object value = primaryRow.get(primaryField);
            referenceQueryInfo.addEqualInfo(referenceField, value);
        }
    }

    @Override
    @Deprecated
    public DWDataRow selectOne(DWQueryInfo queryInfo, String sql) {
        return this.selectOne(queryInfo, sql, null);
    }

    @Override
    @Deprecated
    public DWDataRow selectOne(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        DWDataSet dataset = this.select(queryInfo, sql, option);
        DWDataTable primaryTable = dataset.getTables().getPrimaryTable();
        int size = primaryTable.getRows().size();
        if (size > 1) {
            throw new DWDataException("13015", "There are more than one row in dataset!");
        }
        if (size == 0) {
            return null;
        }
        return primaryTable.getRow(0);
    }

    @Override
    public DWDataRow selectOne(DWQueryInfo queryInfo) {
        DWDataSetOperationOption option = null;
        return this.selectOne(queryInfo, option);
    }

    @Override
    public DWDataRow selectOne(DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        String sql = null;
        return this.selectOne(queryInfo, sql, option);
    }

    @Override
    @Deprecated
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, String sql) {
        return this.selectWithPage(pagableQueryInfo, sql, null);
    }

    @Override
    @Deprecated
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, String sql, DWDataSetOperationOption option) {
        if (option == null) {
            option = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        int totalCount = this.selectTotalCount(pagableQueryInfo, sql, option);
        DWDataTableHandler dwDataTableHandler = new DWDataTableHandler(pagableQueryInfo);
        DWDataTable dataTable = this.selectWithPage(pagableQueryInfo, sql, option, dwDataTableHandler);
        this.cascadeSelect(dataTable, option);
        DWDataSet dataset = dataTable.getDataSet();
        DWPaginationQueryResult paginationQueryResult = new DWPaginationQueryResult(pagableQueryInfo.getPageSize(), totalCount);
        paginationQueryResult.setCurrentPage(pagableQueryInfo.getPageNumber(), dataset);
        return paginationQueryResult;
    }

    @Override
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo) {
        return this.selectWithPage(pagableQueryInfo, null, null);
    }

    @Override
    public DWPaginationQueryResult selectWithPage(DWPagableQueryInfo pagableQueryInfo, DWDataSetOperationOption option) {
        return this.selectWithPage(pagableQueryInfo, null, option);
    }

    @Override
    public DWSQLExecutionResult execute(DWDataSet dataset) {
        return this.execute(dataset, null);
    }

    @Override
    public DWSQLExecutionResult execute(DWDataSet dataset, DWDataSetOperationOption option) {
        if (null == dataset) {
            throw new IllegalArgumentException("dataset cannot be null!!");
        }
        if (option == null) {
            option = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        option.set("insertDefaultValueFromMetadata", this.insertDefaultValueFromMetadata);
        option.set("updateDefaultValueFromMetadata", this.updateDefaultValueFromMetadata);
        String operation = "";
        DWDataSetSqlInfo datasqlInfo = this.getDialect().parse(option, dataset);
        DWSQLExecutionResult resultInfo = new DWSQLExecutionResult();
        String tableName = "";
        int index = -1;
        try {
            for (DWDataRowSqlInfo rowSqlInfo : datasqlInfo) {
                ++index;
                operation = rowSqlInfo.getState();
                tableName = rowSqlInfo.getTableName();
                switch (operation) {
                    case "C": {
                        int count;
                        rowSqlInfo.updateAutoIncrementRefColumnValues(option);
                        boolean returnGeneratedKeys = option.getTableStatementOption().isReturnGeneratedKeys(tableName);
                        if (rowSqlInfo.getMetadata().getAutoIncrement() != null && returnGeneratedKeys) {
                            List<Object> generatedKeys = this.insertReturnGeneratedKeys(rowSqlInfo, option);
                            count = generatedKeys.size();
                            resultInfo.addGeneratedKeys(tableName, generatedKeys);
                        } else {
                            count = this.insert(rowSqlInfo, option);
                        }
                        resultInfo.addInsertCount(tableName, count);
                        break;
                    }
                    case "U": {
                        int count = this.update(rowSqlInfo, option);
                        resultInfo.addUpdateCount(tableName, count);
                        break;
                    }
                    case "D": {
                        DWDeleteConstraint deleteConstraint = new DWDeleteConstraint();
                        deleteConstraint.check(rowSqlInfo, option);
                        this.cascadeDelete(option, rowSqlInfo, resultInfo);
                        int count = this.delete(rowSqlInfo);
                        resultInfo.addDeleteCount(tableName, count);
                        break;
                    }
                    default: {
                        throw new DWDataException("13008", String.format("This Operation[%s] is unknown!", operation));
                    }
                }
                rowSqlInfo.persist();
            }
        }
        catch (DWDataException e) {
            e.rethrow((Throwable)((Object)e), tableName, operation, datasqlInfo, index);
        }
        catch (Exception e) {
            new DWDataException().rethrow("13029", e, tableName, operation, datasqlInfo, index);
        }
        return resultInfo;
    }

    public int insert(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        DWBatchDataRowSqlInfo batchSqlInfo;
        int[] batchResult;
        int result = 0;
        result = sqlInfo instanceof DWBatchDataRowSqlInfo ? ((batchResult = this.innerBatch(batchSqlInfo = (DWBatchDataRowSqlInfo)sqlInfo, option)).length > 0 && batchResult[0] == -2 ? -2 : Arrays.stream(batchResult).sum()) : this.innerUpdate(sqlInfo, option);
        return result;
    }

    public List<Object> insertReturnGeneratedKeys(DWSqlInfo sqlInfo) {
        List<Object> generatedKeys = this.insertReturnGeneratedKeys(sqlInfo, null);
        return generatedKeys;
    }

    public List<Object> insertReturnGeneratedKeys(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        List<Map<String, Object>> insertResult;
        boolean isDataRowSqlInfo = sqlInfo instanceof DWDataRowSqlInfo;
        boolean isBatchDataRowSqlInfo = sqlInfo instanceof DWBatchDataRowSqlInfo;
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            DWBatchDataRowSqlInfo batchInfo = (DWBatchDataRowSqlInfo)sqlInfo;
            insertResult = this.innerInsertBatch(batchInfo, option);
        } else {
            insertResult = this.innerInsert(sqlInfo, option);
        }
        List<Object> generatedKeys = null;
        generatedKeys = insertResult == null ? Collections.emptyList() : insertResult.stream().map(i -> i.get("insert_id")).collect(Collectors.toList());
        if (isDataRowSqlInfo) {
            DWDataRowSqlInfo rowSqlInfo = (DWDataRowSqlInfo)sqlInfo;
            if (isBatchDataRowSqlInfo) {
                DWBatchDataRowSqlInfo batchInfo = (DWBatchDataRowSqlInfo)sqlInfo;
                batchInfo.setGeneratedKeys(generatedKeys);
            } else if (generatedKeys.size() == 1) {
                rowSqlInfo.getRow().set(rowSqlInfo.getMetadata().getAutoIncrement(), generatedKeys.get(0));
            } else if (generatedKeys.size() > 1 && DWDataRowCondition.getInsertFrom(rowSqlInfo.getRow()) == null) {
                throw new DWDataException("13011", String.format("This row(%s) generate more than one keys!", rowSqlInfo.getRow()));
            }
        }
        return generatedKeys;
    }

    private int updateBatch(DWBatchDataRowSqlInfo batchSqlInfo, DWDataSetOperationOption options) {
        int[] result = new int[]{};
        result = this.innerBatch(batchSqlInfo, options);
        if (batchSqlInfo.hasLockingInfo()) {
            for (int i = 0; i < batchSqlInfo.getRowCount(); ++i) {
                DWDataOptimisticLockingInfo lockingInfo = batchSqlInfo.getLockingInfo(i);
                if (lockingInfo == null || result[i] == 1) continue;
                throw new DWDataOptimisticLockingException(lockingInfo);
            }
        }
        return Arrays.stream(result).sum();
    }

    public int update(DWSqlInfo sqlInfo) {
        int result = this.update(sqlInfo, null);
        return result;
    }

    public int update(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            return this.updateBatch((DWBatchDataRowSqlInfo)sqlInfo, option);
        }
        int result = 0;
        result = this.innerUpdate(sqlInfo, option);
        DWDataOptimisticLockingInfo lockingInfo = sqlInfo.getLockingInfo();
        if (lockingInfo != null && result != 1) {
            throw new DWDataOptimisticLockingException(lockingInfo);
        }
        return result;
    }

    private void cascadeDelete(DWDataSetOperationOption options, DWDataRowSqlInfo sqlInfo, DWSQLExecutionResult resultInfo) {
        List<DWCascadeDeletingInfo> deleteList = options.getCascadingDeletingList();
        if (deleteList.size() == 0) {
            return;
        }
        DWDataRow dataRow = sqlInfo.getRow();
        DWDataTable dataTable = dataRow.getDataTable();
        String primaryTableName = dataTable.getName();
        CascadeDeletingInstruction instruction = new CascadeDeletingInstruction(primaryTableName, options, resultInfo);
        if (!instruction.hasReferenceCascadeSetting()) {
            return;
        }
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            throw new DWDataException("Batch Mode is not support cascade deleting.");
        }
        for (DWCascadeDeletingInfo cascadeTarget : instruction.getCascadeDeletingList()) {
            this.cascadeDelete(options, dataRow, cascadeTarget, instruction);
        }
    }

    private boolean cascadeDelete(DWDataSetOperationOption options, DWDataRow sourceRow, DWCascadeDeletingInfo cascadeDeleteInfo, CascadeDeletingInstruction instruction) {
        String primaryTableName = cascadeDeleteInfo.getReference();
        CascadeDeletingInstruction innerInstruction = new CascadeDeletingInstruction(primaryTableName, instruction.option, instruction.resultInfo);
        boolean hasReferenceCascadeSetting = innerInstruction.hasReferenceCascadeSetting();
        if (hasReferenceCascadeSetting) {
            HashMap<DWCascadeDeletingInfo, Boolean> cascadeDeleteReference = new HashMap<DWCascadeDeletingInfo, Boolean>();
            DWDataTable refDataTable = this.queryCascadeDeletingDataRows(sourceRow, cascadeDeleteInfo, instruction);
            for (DWDataRow dataRow : refDataTable.getRows()) {
                for (DWCascadeDeletingInfo cascadeTarget : innerInstruction.getCascadeDeletingList()) {
                    if (cascadeDeleteReference.containsKey(cascadeTarget) && !((Boolean)cascadeDeleteReference.get(cascadeTarget)).booleanValue()) continue;
                    cascadeDeleteReference.put(cascadeTarget, this.cascadeDelete(options, dataRow, cascadeTarget, innerInstruction));
                }
            }
            log.info((Object)String.format(">Cascade delete (%s)...source row (%s)", primaryTableName, sourceRow));
            int count = refDataTable.getRows().size();
            for (int i = count - 1; i >= 0; --i) {
                refDataTable.getRows().deleteAt(i);
            }
            DWSQLExecutionResult result = this.execute(refDataTable.getDataSet());
            if (result instanceof DWSQLExecutionResult) {
                DWSQLExecutionResult cascadeDeleteResult = result;
                int deleteCount = cascadeDeleteResult.getDeleteCount();
                innerInstruction.resultInfo.addDeleteCount(refDataTable.getName(), deleteCount);
            }
        } else {
            DWRdbmsRelationshipAttribute relation = instruction.getMappingAttribute(cascadeDeleteInfo);
            DWQueryCondition rowDeleteCondition = new DWQueryCondition();
            for (Map.Entry item : relation.getJoinColumns().entrySet()) {
                rowDeleteCondition.addEqualInfo((String)item.getValue(), sourceRow.get((String)item.getKey()));
            }
            DWQueryCondition userDefinedCondition = cascadeDeleteInfo.getCondition().clone();
            rowDeleteCondition.addCondition(userDefinedCondition);
            DWSqlInfo sqlInfo = this.getDialect().parseDeleteSql(options, primaryTableName, rowDeleteCondition);
            log.info((Object)String.format(">Cascade delete (%s)...source row (%s)", primaryTableName, sourceRow));
            int delectCount = this.delete(sqlInfo);
            instruction.resultInfo.addDeleteCount(primaryTableName, delectCount);
        }
        return hasReferenceCascadeSetting;
    }

    private DWDataTable queryCascadeDeletingDataRows(DWDataRow sourceRow, DWCascadeDeletingInfo cascadeTarget, CascadeDeletingInstruction instruction) {
        DWRdbmsRelationshipAttribute relation = instruction.getMappingAttribute(cascadeTarget);
        Map joinColumns = relation.getJoinColumns();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(relation.getDetailTableName());
        DWQueryInfo queryInfo = new DWQueryInfo();
        for (Map.Entry item : joinColumns.entrySet()) {
            Object value = sourceRow.get((String)item.getKey());
            queryInfo.addEqualInfo((String)item.getValue(), value);
        }
        queryInfo.getCondition().addCondition(cascadeTarget.getCondition().clone());
        DWDataSet dataset = this.select(queryInfo, sql.toString(), instruction.option);
        DWDataTable dataTable = dataset.getTable(relation.getDetailTableName());
        return dataTable;
    }

    public int delete(DWSqlInfo sqlInfo) {
        int result = this.delete(sqlInfo, null);
        return result;
    }

    public int delete(DWSqlInfo sqlInfo, DWDataSetOperationOption option) {
        if (sqlInfo instanceof DWBatchDataRowSqlInfo) {
            return this.updateBatch((DWBatchDataRowSqlInfo)sqlInfo, option);
        }
        int result = 0;
        result = this.innerUpdate(sqlInfo, option);
        DWDataOptimisticLockingInfo lockingInfo = sqlInfo.getLockingInfo();
        if (lockingInfo != null && result != 1) {
            throw new DWDataOptimisticLockingException(lockingInfo);
        }
        return result;
    }

    private class CascadeDeletingInstruction {
        private String primaryTableName;
        private DWSQLExecutionResult resultInfo;
        private DWDataSetOperationOption option;
        private List<DWCascadeDeletingInfo> deleteList;
        private Collection<DWRdbmsRelationshipAttribute> relations = null;

        private CascadeDeletingInstruction(String primaryTableName, DWDataSetOperationOption option, DWSQLExecutionResult resultInfo) {
            this.primaryTableName = primaryTableName;
            this.option = option;
            this.resultInfo = resultInfo;
            this.parse();
        }

        private void parse() {
            List<DWCascadeDeletingInfo> allSetting = this.option.getCascadingDeletingList();
            this.deleteList = allSetting.stream().filter(item -> this.primaryTableName.equals(item.getPrimary())).collect(Collectors.toList());
            if (this.deleteList.size() > 0) {
                DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get((String)this.primaryTableName, DWRdbmsMetadata.class);
                this.relations = metadata.getAttributes(DWRdbmsRelationshipAttribute.class);
            }
        }

        private boolean hasReferenceCascadeSetting() {
            return this.deleteList.size() > 0;
        }

        private List<DWCascadeDeletingInfo> getCascadeDeletingList() {
            return this.deleteList;
        }

        private DWRdbmsRelationshipAttribute getMappingAttribute(DWCascadeDeletingInfo cascadTarget) {
            if (this.relations == null) {
                throw new DWDataException("13017", String.format("This table(%s) has no any cascade deleting setting!", this.primaryTableName));
            }
            String referenceName = cascadTarget.getReference();
            DWRdbmsRelationshipAttribute targetAttribute = this.relations.stream().filter(attr -> attr.getDetailTableName().equals(referenceName)).findFirst().get();
            if (targetAttribute == null) {
                throw new DWDataException("13018", String.format("cascade Query reference(%s) is not found in metadata", referenceName));
            }
            return targetAttribute;
        }
    }
}

