/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.exceptions.DWDataColumnDuplicateException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DWDataColumnCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient DWDataTable table;
    private List<String> columns;

    protected DWDataColumnCollection(DWDataTable owner) {
        this.table = owner;
        this.columns = new ArrayList<String>();
    }

    public DWDataColumnCollection add(String ... names) {
        if (names == null || names.length == 0) {
            throw new IllegalArgumentException("names is null or empty!");
        }
        for (String name : names) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("name is null or empty!");
            }
            if (this.columns.contains(name)) {
                throw new DWDataColumnDuplicateException(name);
            }
            this.columns.add(name);
        }
        return this;
    }

    public String[] getColumnNames() {
        String[] array = new String[this.columns.size()];
        array = this.columns.toArray(array);
        return array;
    }

    public boolean hasColumn(String name) {
        return this.columns.contains(name);
    }
}

