/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import com.digiwin.app.dao.dbutils.DecryptColumn;
import com.digiwin.app.dao.dbutils.DecryptColumnType;
import com.digiwin.app.dao.filter.DWSQLManagementFieldFilter;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DWSQLOptionsBuilder {
    public static String OPTION_INSERT_OPTION = "insertOption";
    public static String OPTION_CASCADE_QUERIES = "cascadeQueries";
    public static String OPTION_CASCADE_DELETINGS = "cascadeDeletings";
    public static String OPTION_TENANT_ENABLED = "tenantEnabled";
    public static String OPTION_TENANT_DISABLED_TABLE_NAMES = "tenantDisabledTableNames";
    public static String OPTION_SELECT_VERSION_FIELD_ENABLED = "selectVersionFieldEnabled";
    public static String OPTION_RELATED_TABLE_TENANT_ENABLED = "relatedTableTenantEnabled";
    public static String OPTION_CACULATE_MAX_SEQ_ENABLED = "calculateMaxSeqEnabled";
    public static String OPTION_CACULATE_MAX_SEQ_FIELD_NAME = "calculateMaxSeqFieldName";
    public static String OPTION_ENCRYPT = "encrypt";
    public static String OPTION_DECRYPT = "decrypt";
    public static String OPTION_LOG_OPERATION_ENABLED = "logOperationEnabled";
    public static final String OPTION_INSERT_DEFAULT_VALUE_FROM_METADATA = "insertDefaultValueFromMetadata";
    public static final String OPTION_UPDATE_DEFAULT_VALUE_FROM_METADATA = "updateDefaultValueFromMetadata";
    public static final String OPTION_CUSTOM_INSERT_DEFAULT_VALUE_FROM_METADATA = "customInsertDefaultValueFromMetadata";
    public static final String OPTION_CUSTOM_UPDATE_DEFAULT_VALUE_FROM_METADATA = "customUpdateDefaultValueFromMetadata";
    public static String OPTION_TABLE_STATEMENT_OPTION = "tableStatementOption";
    public static String OPTION_SQL_ORDER_TYPE_OF_EXECUTION = "sqlOrderTypeOfExecution";
    public static String SQL_ORDER_TYPE_DELETE_HIGH_PRIORITY = "deleteHighPriority";
    private DWDataSetOperationOption options = new DWDataSetOperationOption();

    public static DWSQLOptionsBuilder custom() {
        return new DWSQLOptionsBuilder();
    }

    public DWSQLOptionsBuilder setTenantEnabled(boolean enabled) {
        this.options.setTenantEnabled(enabled);
        return this;
    }

    public DWSQLOptionsBuilder setManagementFieldEnabled(boolean enabled) {
        DWSQLManagementFieldFilter.setEnabledInOptions(this.options, enabled);
        return this;
    }

    public DWSQLOptionsBuilder addEncryptColumns(String ... columnNames) {
        HashSet newColumnNameSet = new HashSet();
        Collections.addAll(newColumnNameSet, columnNames);
        Set currentColumnNameSet = this.options.get(OPTION_ENCRYPT, new HashSet());
        currentColumnNameSet.addAll(newColumnNameSet);
        this.options.set(OPTION_ENCRYPT, currentColumnNameSet);
        return this;
    }

    public DWSQLOptionsBuilder addDecryptColumns(String ... columnNames) {
        Map currentDecryptColumnMap = this.options.get(OPTION_DECRYPT, new HashMap());
        for (String columnName : columnNames) {
            currentDecryptColumnMap.put(columnName, DecryptColumnType.CHAR);
        }
        this.options.set(OPTION_DECRYPT, currentDecryptColumnMap);
        return this;
    }

    public DWSQLOptionsBuilder addDecryptColumns(DecryptColumn ... decryptColumns) {
        Map currentDecryptColumnMap = this.options.get(OPTION_DECRYPT, new HashMap());
        for (DecryptColumn decryptColumn : decryptColumns) {
            currentDecryptColumnMap.put(decryptColumn.getColumnName(), decryptColumn.getDecryptColumnType());
        }
        this.options.set(OPTION_DECRYPT, currentDecryptColumnMap);
        return this;
    }

    public IDWSQLOptions create() {
        return this.options;
    }
}

