/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.generic;

import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryBeanResult;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.basic.DWBasicDaoImpl;
import com.digiwin.app.dao.basic.DWDataSetOperationOptionBuilder;
import com.digiwin.app.dao.generic.DWGenericDao;
import com.digiwin.app.dao.processor.DWBeanProcessor;
import com.digiwin.app.dao.processor.DWGenerousBeanProcessor;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;

public class DWGenericDaoImpl
extends DWBasicDaoImpl
implements DWGenericDao {
    private boolean mapUnderscoreToCamelCase = true;

    public DWGenericDaoImpl(QueryRunner queryRunner) {
        super(queryRunner);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, String statement, Object ... params) {
        RowProcessor rowProcessor = this.getRowProcessor();
        return this.select(clazz, rowProcessor, statement, params);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, RowProcessor rowProcessor, String statement, Object ... params) {
        return this.select(null, clazz, rowProcessor, statement, params);
    }

    @Override
    public <T> List<T> select(IDWSQLOptions options, Class<T> clazz, String statement, Object ... params) {
        RowProcessor rowProcessor = this.getRowProcessor();
        return this.select(options, clazz, rowProcessor, statement, params);
    }

    @Override
    public <T> List<T> select(IDWSQLOptions options, Class<T> clazz, RowProcessor rowProcessor, String statement, Object ... params) {
        if (options == null) {
            options = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        options = DWDataSetOperationOptionBuilder.disabledManagementFields(options);
        DWSqlInfo sqlInfo = this.getDialect().parse(options, statement, params);
        BeanListHandler beanListHandler = new BeanListHandler(clazz, rowProcessor);
        return (List)this.innerQuery(sqlInfo, beanListHandler, options);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, DWQueryInfo queryInfo) {
        return this.select(clazz, queryInfo, null);
    }

    @Override
    public <T> List<T> select(Class<T> clazz, DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        BeanListHandler beanListHandler = new BeanListHandler(clazz, this.getRowProcessor());
        return (List)this.select(queryInfo, null, option, (ResultSetHandler<T>)beanListHandler);
    }

    protected <T> T select(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option, ResultSetHandler<T> resultSetHandler) {
        if (option == null) {
            option = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        DWSqlInfo sqlInfo = this.getDialect().parse(option, queryInfo, sql);
        return this.innerQuery(sqlInfo, resultSetHandler, option);
    }

    @Override
    public <T> T selectOne(Class<T> clazz, DWQueryInfo queryInfo) {
        return this.selectOne(clazz, queryInfo, null);
    }

    @Override
    public <T> T selectOne(Class<T> clazz, DWQueryInfo queryInfo, DWDataSetOperationOption option) {
        List<T> result = this.select(clazz, queryInfo, option);
        if (result.size() > 1) {
            throw new DWDataException("13015", "There are more than one row in result list!");
        }
        if (result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    @Override
    public <T> DWPaginationQueryBeanResult<T> selectWithPage(Class<T> clazz, DWPagableQueryInfo pagableQueryInfo) {
        return this.selectWithPage(clazz, pagableQueryInfo, null);
    }

    @Override
    public <T> DWPaginationQueryBeanResult<T> selectWithPage(Class<T> clazz, DWPagableQueryInfo pagableQueryInfo, DWDataSetOperationOption option) {
        if (option == null) {
            option = DWDataSetOperationOptionBuilder.createDefaultOption();
        }
        int totalCount = this.selectTotalCount(pagableQueryInfo, null, option);
        BeanListHandler beanListHandler = new BeanListHandler(clazz, this.getRowProcessor());
        List data = (List)this.selectWithPage(pagableQueryInfo, null, option, (ResultSetHandler<T>)beanListHandler);
        DWPaginationQueryBeanResult result = new DWPaginationQueryBeanResult(pagableQueryInfo.getPageSize(), totalCount);
        result.setCurrentPage(pagableQueryInfo.getPageNumber(), data);
        return result;
    }

    protected int selectTotalCount(DWPagableQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        int totalCount = 0;
        List countResult = new ArrayList();
        DWSqlInfo countSqlInfo = this.getDialect().parseCount(option, queryInfo, sql);
        countResult = (List)this.innerQuery(countSqlInfo, new MapListHandler(), option);
        if (null != countResult && null != countResult.get(0)) {
            Map countRow = (Map)countResult.get(0);
            Map.Entry countCell = countRow.entrySet().iterator().next();
            totalCount = Integer.parseInt(countCell.getValue().toString());
        }
        return totalCount;
    }

    protected <T> T selectWithPage(DWPagableQueryInfo queryInfo, String sql, DWDataSetOperationOption option, ResultSetHandler<T> resultSetHandler) {
        DWSqlInfo sqlInfo = this.getDialect().parse(option, queryInfo, sql);
        return this.innerQuery(sqlInfo, resultSetHandler, option);
    }

    public void setMapUnderscoreToCamelCase(boolean mapUnderscoreToCamelCase) {
        this.mapUnderscoreToCamelCase = mapUnderscoreToCamelCase;
    }

    private RowProcessor getRowProcessor() {
        if (this.mapUnderscoreToCamelCase) {
            return new BasicRowProcessor((BeanProcessor)new DWGenerousBeanProcessor());
        }
        return new BasicRowProcessor((BeanProcessor)new DWBeanProcessor());
    }
}

